/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class EntityAIEatToHeal
extends Goal {
    private final EntityKoaBase entityObj;
    private int walkingTimeoutMax = 200;
    private int walkingTimeout;
    private int repathPentalty = 0;
    private int lookUpdateTimer = 0;
    private int randXPos = 0;
    private int randYPos = 0;
    private int randZPos = 0;
    private float missingHealthToHeal = 5.0f;

    public EntityAIEatToHeal(EntityKoaBase entityObjIn) {
        this.entityObj = entityObjIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.entityObj.func_110143_aJ() < this.entityObj.func_110138_aP() - this.missingHealthToHeal) {
            return this.hasFoodSource();
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.hasFoodSource((IInventory)this.entityObj.inventory)) {
            this.consumeOneStackSizeOfFood((IInventory)this.entityObj.inventory);
            this.entityObj.func_70691_i(5.0f);
            this.entityObj.field_70170_p.func_184133_a(null, this.entityObj.func_233580_cy_(), SoundEvents.field_187739_dZ, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            return;
        }
        if (this.hasFoodAtHome()) {
            boolean isClose = false;
            BlockPos blockposGoal = this.entityObj.func_213384_dI();
            if (blockposGoal == null) {
                this.func_75251_c();
                return;
            }
            double dist = this.entityObj.func_213303_ch().func_72438_d(new Vector3d((double)blockposGoal.func_177958_n(), (double)blockposGoal.func_177956_o(), (double)blockposGoal.func_177952_p()));
            if (dist < 5.0) {
                this.consumeOneStackSizeOfFoodAtHome();
                this.entityObj.func_70691_i(5.0f);
                this.entityObj.field_70170_p.func_184133_a(null, this.entityObj.func_233580_cy_(), SoundEvents.field_187739_dZ, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                return;
            }
            if (!isClose) {
                if ((this.entityObj.func_70661_as().func_75500_f() || this.walkingTimeout <= 0) && this.repathPentalty <= 0) {
                    int i = blockposGoal.func_177958_n();
                    int j = blockposGoal.func_177956_o();
                    int k = blockposGoal.func_177952_p();
                    boolean success = false;
                    if (this.entityObj.func_195048_a(Vector3d.func_237489_a_((Vector3i)blockposGoal)) > 256.0) {
                        Vector3d Vector3d2 = RandomPositionGenerator.func_234133_a_((CreatureEntity)this.entityObj, (int)14, (int)3, (Vector3d)new Vector3d((double)i + 0.5, (double)j, (double)k + 0.5));
                        if (Vector3d2 != null) {
                            success = this.entityObj.func_70661_as().func_75492_a(Vector3d2.field_72450_a, Vector3d2.field_72448_b, Vector3d2.field_72449_c, 1.0);
                        }
                    } else {
                        success = this.entityObj.func_70661_as().func_75492_a((double)i + 0.5, (double)j, (double)k + 0.5, 1.0);
                    }
                    if (!success) {
                        this.repathPentalty = 40;
                    } else {
                        this.walkingTimeout = this.walkingTimeoutMax;
                    }
                } else if (this.walkingTimeout > 0) {
                    --this.walkingTimeout;
                }
            }
            if (this.repathPentalty > 0) {
                --this.repathPentalty;
            }
            if (this.lookUpdateTimer > 0) {
                --this.lookUpdateTimer;
            }
        }
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.entityObj.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.entityObj.setSitting(false);
        this.walkingTimeout = 0;
    }

    public boolean isTooClose() {
        BlockPos blockposGoal = null;
        blockposGoal = this.entityObj.posLastFireplaceFound != null ? this.entityObj.posLastFireplaceFound.func_177982_a(0, -1, 0) : this.entityObj.func_213384_dI();
        if (blockposGoal == null) {
            return false;
        }
        double dist = this.entityObj.func_213303_ch().func_72438_d(new Vector3d((double)blockposGoal.func_177958_n(), (double)blockposGoal.func_177956_o(), (double)blockposGoal.func_177952_p()));
        return dist <= 3.0;
    }

    public boolean hasFoodSource() {
        if (this.hasFoodSource((IInventory)this.entityObj.inventory)) {
            return true;
        }
        return this.hasFoodAtHome();
    }

    public boolean hasFoodAtHome() {
        ChestTileEntity chest;
        TileEntity tile;
        BlockPos blockposGoal = this.entityObj.func_213384_dI();
        return blockposGoal != null && (tile = this.entityObj.field_70170_p.func_175625_s(blockposGoal)) instanceof ChestTileEntity && this.hasFoodSource((IInventory)(chest = (ChestTileEntity)tile));
    }

    public boolean hasFoodSource(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !stack.func_77973_b().func_219971_r()) continue;
            return true;
        }
        return false;
    }

    public ItemStack consumeOneStackSizeOfFoodAtHome() {
        TileEntity tile;
        BlockPos blockposGoal = this.entityObj.func_213384_dI();
        if (blockposGoal != null && (tile = this.entityObj.field_70170_p.func_175625_s(blockposGoal)) instanceof ChestTileEntity) {
            ChestTileEntity chest = (ChestTileEntity)tile;
            return this.consumeOneStackSizeOfFood((IInventory)chest);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack consumeOneStackSizeOfFood(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !stack.func_77973_b().func_219971_r()) continue;
            stack.func_190918_g(1);
            if (stack.func_190916_E() <= 0) {
                inv.func_70299_a(i, ItemStack.field_190927_a);
            }
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190920_e(1);
            return newStack;
        }
        return ItemStack.field_190927_a;
    }
}

