/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class EntityAIKoaMate
extends Goal {
    private final EntityKoaBase villagerObj;
    private EntityKoaBase mate;
    private final World world;
    private int matingTimeout;
    private final long TIME_BETWEEN_POPULATION_CHECKS = 200L;
    private final int MAX_TOWN_POPULATION = 10;
    private long lastTimeCheckedVillagePopulation = -1L;
    private int cachedVillagePopulation = 0;

    public EntityAIKoaMate(EntityKoaBase villagerIn) {
        this.villagerObj = villagerIn;
        this.world = villagerIn.field_70170_p;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.villagerObj.func_70874_b() != 0) {
            return false;
        }
        if (this.villagerObj.func_70681_au().nextInt(500) != 0) {
            return false;
        }
        if (this.canTownHandleMoreVillagers() && this.villagerObj.getIsWillingToMate(true)) {
            List listEntities = this.world.func_217357_a(EntityKoaBase.class, this.villagerObj.func_174813_aQ().func_72314_b(8.0, 3.0, 8.0));
            EntityKoaBase clEnt = null;
            double clDist = 9999.0;
            for (EntityKoaBase ent : listEntities) {
                if (ent == this.villagerObj || !this.villagerObj.willBone(ent) || !((double)this.villagerObj.func_70032_d((Entity)ent) < clDist)) continue;
                clEnt = ent;
                clDist = this.villagerObj.func_70032_d((Entity)ent);
            }
            if (clEnt != null) {
                this.mate = clEnt;
                return true;
            }
        }
        return false;
    }

    public void func_75249_e() {
        this.matingTimeout = 300;
        this.villagerObj.setMating(true);
        if (this.mate != null) {
            this.mate.setMating(true);
        }
    }

    public void func_75251_c() {
        this.mate = null;
        this.villagerObj.setMating(false);
    }

    public boolean func_75253_b() {
        boolean result;
        boolean bl = result = this.matingTimeout >= 0 && this.canTownHandleMoreVillagers() && this.villagerObj.func_70874_b() == 0 && this.villagerObj.getIsWillingToMate(false);
        if (!result) {
            // empty if block
        }
        return result;
    }

    public void func_75246_d() {
        --this.matingTimeout;
        this.villagerObj.func_70671_ap().func_75651_a((Entity)this.mate, 10.0f, 30.0f);
        if (this.villagerObj.func_70068_e((Entity)this.mate) > 2.25) {
            this.villagerObj.func_70661_as().func_75497_a((Entity)this.mate, 0.75);
        } else if (this.matingTimeout == 0 && this.mate.isMating()) {
            this.mate.setMating(false);
            if (this.villagerObj.getOrientation() == EntityKoaBase.Orientations.STRAIT) {
                this.giveBirth();
            }
        }
        if (this.villagerObj.func_70681_au().nextInt(35) == 0) {
            this.world.func_72960_a((Entity)this.villagerObj, (byte)12);
        }
    }

    private boolean canTownHandleMoreVillagers() {
        double range = 100.0;
        if (this.lastTimeCheckedVillagePopulation + 200L < this.world.func_82737_E()) {
            this.lastTimeCheckedVillagePopulation = this.world.func_82737_E();
            List listEntities = this.world.func_217357_a(EntityKoaBase.class, this.villagerObj.func_174813_aQ().func_72314_b(range, range, range));
            this.cachedVillagePopulation = listEntities.size();
            return listEntities.size() < 10;
        }
        return this.cachedVillagePopulation < 10;
    }

    private void giveBirth() {
        VillagerEntity entityvillager = this.villagerObj.func_241840_a((ServerWorld)this.world, (AgeableEntity)this.mate);
        this.mate.func_70873_a(6000);
        this.villagerObj.func_70873_a(6000);
        this.mate.setIsWillingToMate(false);
        this.villagerObj.setIsWillingToMate(false);
        entityvillager.func_70873_a(-24000);
        entityvillager.func_70012_b(this.villagerObj.func_226277_ct_(), this.villagerObj.func_226278_cu_(), this.villagerObj.func_226281_cx_(), 0.0f, 0.0f);
        if (entityvillager instanceof EntityKoaBase) {
            ((EntityKoaBase)entityvillager).setVillageAndDimID(this.villagerObj.getVillageID(), this.villagerObj.getVillageDimension());
            entityvillager.func_213390_a(this.villagerObj.func_213384_dI(), EntityKoaBase.MAX_HOME_DISTANCE);
            ((EntityKoaBase)entityvillager).updateUniqueEntityAI();
            entityvillager.field_70170_p.func_184133_a(null, entityvillager.func_233580_cy_(), SoundEvents.field_187665_Y, SoundCategory.AMBIENT, 1.0f, 1.0f);
        }
        this.world.func_217376_c((Entity)entityvillager);
        this.world.func_72960_a((Entity)entityvillager, (byte)12);
    }
}

