/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.vmonkey;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.Hand;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;

public class MonkeyPickUpPinaColadaGoal
extends Goal {
    private VMonkeyEntity entity;
    private ItemEntity drinkEntity;
    private final double speedModifier;
    private final PathNavigator navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;

    public MonkeyPickUpPinaColadaGoal(VMonkeyEntity monkey) {
        this.entity = monkey;
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.speedModifier = 1.0;
        this.stopDistance = 1.0f;
        this.navigation = this.entity.func_70661_as();
        this.drinkEntity = null;
    }

    public boolean func_75253_b() {
        return !this.entity.func_70909_n() && !this.entity.selfHoldingDrink(Drink.PINA_COLADA) && this.drinkEntity != null;
    }

    public boolean func_75250_a() {
        if (this.entity.func_70681_au().nextInt(20) != 0) {
            return false;
        }
        return !this.entity.func_70909_n() && !this.entity.selfHoldingDrink(Drink.PINA_COLADA) && this.hasNearbyDrink(Drink.PINA_COLADA) && this.drinkEntity != null;
    }

    public void func_75251_c() {
        this.navigation.func_75499_g();
        this.entity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.func_184643_a(PathNodeType.WATER);
        this.entity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    private boolean hasNearbyDrink(Drink drink) {
        ItemStack stack = MixerRecipes.getItemStack(drink);
        List list = this.entity.field_70170_p.func_217357_a(ItemEntity.class, this.entity.func_174813_aQ().func_186662_g(10.0));
        if (!list.isEmpty()) {
            for (ItemEntity item : list) {
                if (item.func_82150_aj() || !item.func_92059_d().func_77969_a(stack) || !item.func_70089_S()) continue;
                this.drinkEntity = item;
                return true;
            }
        }
        return false;
    }

    public void func_75246_d() {
        if (this.drinkEntity != null && !this.entity.func_110167_bD()) {
            this.entity.func_70671_ap().func_75651_a((Entity)this.drinkEntity, 10.0f, (float)this.entity.func_70646_bf());
            if (!this.drinkEntity.func_70089_S()) {
                this.drinkEntity = null;
                this.entity.setMadAboutStolenAlcohol(true);
                return;
            }
            if (this.entity.func_70068_e((Entity)this.drinkEntity) > (double)(this.stopDistance * this.stopDistance)) {
                if (--this.timeToRecalcPath <= 0) {
                    double d2;
                    double d1;
                    this.timeToRecalcPath = 10;
                    double d0 = this.entity.func_226277_ct_() - this.drinkEntity.func_226277_ct_();
                    double d3 = d0 * d0 + (d1 = this.entity.func_226278_cu_() - this.drinkEntity.func_226278_cu_()) * d1 + (d2 = this.entity.func_226281_cx_() - this.drinkEntity.func_226281_cx_()) * d2;
                    if (d3 > (double)(this.stopDistance * this.stopDistance)) {
                        this.navigation.func_75497_a((Entity)this.drinkEntity, this.speedModifier);
                    } else {
                        this.navigation.func_75499_g();
                        if (d3 <= (double)this.stopDistance) {
                            double d4 = this.drinkEntity.func_226277_ct_() - this.entity.func_226277_ct_();
                            double d5 = this.drinkEntity.func_226281_cx_() - this.entity.func_226281_cx_();
                            this.navigation.func_75492_a(this.entity.func_226277_ct_() - d4, this.entity.func_226278_cu_(), this.entity.func_226281_cx_() - d5, this.speedModifier);
                        }
                    }
                }
            } else {
                this.entity.func_184611_a(Hand.MAIN_HAND, this.drinkEntity.func_92059_d());
                this.drinkEntity.func_70106_y();
            }
        }
    }
}

