/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.egg;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.egg.EggEntity;
import net.tropicraft.core.common.entity.hostile.TropiSpiderEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class TropiSpiderEggEntity
extends EggEntity {
    protected static final DataParameter<Optional<UUID>> MOTHER_UNIQUE_ID = EntityDataManager.func_187226_a(TropiSpiderEggEntity.class, (IDataSerializer)DataSerializers.field_187203_m);

    public TropiSpiderEggEntity(EntityType<? extends EggEntity> type, World world) {
        super(type, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOTHER_UNIQUE_ID, Optional.empty());
    }

    @Nullable
    public UUID getMotherId() {
        return ((Optional)this.field_70180_af.func_187225_a(MOTHER_UNIQUE_ID)).orElse(null);
    }

    public void setMotherId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(MOTHER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (this.getMotherId() == null) {
            nbt.func_74778_a("MotherUUID", "");
        } else {
            nbt.func_74778_a("MotherUUID", this.getMotherId().toString());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        String motherUUID = "";
        if (nbt.func_150297_b("MotherUUID", 8)) {
            motherUUID = nbt.func_74779_i("MotherUUID");
        }
        if (!motherUUID.isEmpty()) {
            this.setMotherId(UUID.fromString(motherUUID));
        }
    }

    @Override
    public boolean shouldEggRenderFlat() {
        return false;
    }

    @Override
    public String getEggTexture() {
        return "spideregg";
    }

    @Override
    public Entity onHatch() {
        ServerWorld serverWorld;
        Entity e;
        if (this.field_70170_p instanceof ServerWorld && this.getMotherId() != null && (e = (serverWorld = (ServerWorld)this.field_70170_p).func_217461_a(this.getMotherId())) instanceof TropiSpiderEntity) {
            return TropiSpiderEntity.haveBaby((TropiSpiderEntity)e);
        }
        return ((EntityType)TropicraftEntities.TROPI_SPIDER.get()).func_200721_a(this.field_70170_p);
    }

    @Override
    public int getHatchTime() {
        return 2000;
    }

    @Override
    public int getPreHatchMovement() {
        return 20;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.TROPI_SPIDER_SPAWN_EGG.get());
    }
}

