/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.hostile;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.ai.EntityAIWanderNotLazy;
import net.tropicraft.core.common.entity.egg.TropiSpiderEggEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class TropiSpiderEntity
extends SpiderEntity {
    private static final DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(TropiSpiderEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final int SPIDER_MATURE_AGE = 12000;
    private static final int SPIDER_MAX_EGGS = 10;
    private static final long SPIDER_MIN_EGG_DELAY = 12000L;
    private static final int SPIDER_EGG_CHANCE = 1000;
    private BlockPos nestSite;
    private TropiSpiderEntity mother = null;
    private long ticksSinceLastEgg = 0L;
    public byte initialType = 0;

    public TropiSpiderEntity(EntityType<? extends SpiderEntity> type, World world) {
        super(type, world);
        this.field_70173_aa = 12000;
        this.ticksSinceLastEgg = this.field_70173_aa;
    }

    public static TropiSpiderEntity haveBaby(TropiSpiderEntity mother) {
        TropiSpiderEntity baby = new TropiSpiderEntity((EntityType<? extends SpiderEntity>)((EntityType)TropicraftEntities.TROPI_SPIDER.get()), mother.field_70170_p);
        baby.setSpiderType(Type.CHILD);
        baby.field_70173_aa = 0;
        baby.mother = mother;
        return baby;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)this.initialType);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.8, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new EntityAIWanderNotLazy((CreatureEntity)this, 0.8, 40));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (damageSrc.func_76346_g() != null && damageSrc.func_76346_g() instanceof LivingEntity) {
            this.func_70624_b((LivingEntity)damageSrc.func_76346_g());
        }
        super.func_70665_d(damageSrc, damageAmount);
    }

    public boolean func_70617_f_() {
        return this.func_70841_p() && this.func_70661_as().func_75500_f();
    }

    public boolean func_70841_p() {
        return this.field_70123_F;
    }

    public void func_70071_h_() {
        this.field_70143_R = 0.0f;
        super.func_70071_h_();
        LivingEntity attackTarget = this.func_70638_az();
        if (attackTarget != null && this.func_70068_e((Entity)attackTarget) < 128.0) {
            Util.tryMoveToEntityLivingLongDist((MobEntity)this, (Entity)attackTarget, 0.8f);
        }
        if (!this.field_70170_p.field_72995_K && attackTarget != null && this.field_70122_E && this.field_70146_Z.nextInt(3) == 0 && attackTarget.func_70032_d((Entity)this) < 5.0f) {
            this.func_70661_as().func_75499_g();
            this.func_70664_aZ();
            this.field_70747_aH = 0.3f;
        } else {
            this.field_70747_aH = 0.2f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getSpiderType() == Type.CHILD) {
                if (this.field_70173_aa >= 12000) {
                    this.setSpiderType(Type.ADULT);
                }
                if (this.mother != null) {
                    if (this.func_70068_e((Entity)this.mother) > 16.0) {
                        Util.tryMoveToEntityLivingLongDist((MobEntity)this, (Entity)this.mother, 0.8f);
                    } else {
                        this.func_70661_as().func_75499_g();
                    }
                    if (this.mother.func_70638_az() != null) {
                        this.func_70624_b(this.mother.func_70638_az());
                    }
                }
            }
            if (this.getSpiderType() == Type.ADULT) {
                if (this.mother != null) {
                    if (!this.mother.func_70089_S()) {
                        this.mother = null;
                        this.func_70661_as().func_75499_g();
                        this.func_70624_b(null);
                    }
                    this.func_70624_b((LivingEntity)this.mother);
                }
                if (this.field_70146_Z.nextInt(1000) == 0 && this.ticksSinceLastEgg > 12000L && this.field_70173_aa % 80 == 0) {
                    this.buildNest();
                }
            }
            if (this.getSpiderType() == Type.MOTHER && this.nestSite != null) {
                if (this.ticksSinceLastEgg < 2000L) {
                    if (!this.func_233580_cy_().func_218141_a((Vector3i)this.nestSite, 16.0)) {
                        Util.tryMoveToXYZLongDist((MobEntity)this, this.nestSite, 0.9f);
                    }
                } else {
                    this.nestSite = null;
                }
            }
            ++this.ticksSinceLastEgg;
        }
    }

    protected SoundEvent func_184639_G() {
        return this.field_70146_Z.nextInt(20) == 0 ? super.func_184639_G() : null;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockState) {
        if (this.getSpiderType() == Type.CHILD) {
            if (this.field_70146_Z.nextInt(20) == 0) {
                super.func_180429_a(pos, blockState);
            }
        } else {
            super.func_180429_a(pos, blockState);
        }
    }

    public boolean func_70104_M() {
        return this.getSpiderType() != Type.MOTHER;
    }

    public void buildNest() {
        if (!this.field_70170_p.field_72995_K) {
            this.setSpiderType(Type.MOTHER);
            int r = this.field_70146_Z.nextInt(10) + 1;
            if (r < 2) {
                return;
            }
            for (int i = 0; i < r; ++i) {
                TropiSpiderEggEntity egg = (TropiSpiderEggEntity)((EntityType)TropicraftEntities.TROPI_SPIDER_EGG.get()).func_200721_a(this.field_70170_p);
                egg.setMotherId(this.func_110124_au());
                egg.func_70107_b((float)this.func_233580_cy_().func_177958_n() + this.field_70146_Z.nextFloat(), this.func_233580_cy_().func_177956_o(), (float)this.func_233580_cy_().func_177952_p() + this.field_70146_Z.nextFloat());
                this.field_70170_p.func_217376_c((Entity)egg);
                this.ticksSinceLastEgg = 0L;
            }
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    BlockPos pos;
                    if (this.field_70146_Z.nextInt(8) != 0 || !this.field_70170_p.func_180495_p(pos = new BlockPos(this.func_233580_cy_().func_177958_n() - 2 + x, this.func_233580_cy_().func_177956_o(), this.func_233580_cy_().func_177952_p() - 2 + z)).func_177230_c().equals(Blocks.field_150350_a) || !this.field_70170_p.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a()) continue;
                    this.field_70170_p.func_175656_a(pos, Blocks.field_196553_aF.func_176223_P());
                }
            }
            this.nestSite = this.func_233580_cy_();
        }
    }

    public void func_213281_b(CompoundNBT n) {
        n.func_74768_a("ticks", this.field_70173_aa);
        n.func_74774_a("spiderType", (byte)this.getSpiderType().ordinal());
        n.func_74772_a("timeSinceLastEgg", this.ticksSinceLastEgg);
        super.func_213281_b(n);
    }

    public void func_70037_a(CompoundNBT n) {
        this.field_70173_aa = n.func_74762_e("ticks");
        this.setSpiderType(n.func_74771_c("spiderType"));
        this.ticksSinceLastEgg = n.func_74763_f("timeSinceLastEgg");
        super.func_70037_a(n);
    }

    public Type getSpiderType() {
        return Type.VALUES[(Byte)this.func_184212_Q().func_187225_a(TYPE)];
    }

    public void setSpiderType(Type type) {
        this.func_184212_Q().func_187227_b(TYPE, (Object)((byte)type.ordinal()));
        this.func_213323_x_();
    }

    public void setSpiderType(byte b) {
        this.func_184212_Q().func_187227_b(TYPE, (Object)b);
        this.func_213323_x_();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.TROPI_SPIDER_SPAWN_EGG.get());
    }

    public static enum Type {
        ADULT,
        MOTHER,
        CHILD;

        private static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

