/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.neutral;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.hostile.TropicraftCreatureEntity;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.sound.Sounds;

public class IguanaEntity
extends TropicraftCreatureEntity {
    private int angerLevel;
    private UUID angerTargetUUID;
    private static final UUID ATTACK_SPEED_BOOST_MODIFIER_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier ATTACK_SPEED_BOOST_MODIFIER = new AttributeModifier(ATTACK_SPEED_BOOST_MODIFIER_UUID, "Attacking speed boost", 0.05, AttributeModifier.Operation.ADDITION);

    public IguanaEntity(EntityType<? extends CreatureEntity> type, World world) {
        super(type, world);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.IGUANA_SPAWN_EGG.get());
    }

    public void func_70604_c(@Nullable LivingEntity entity) {
        super.func_70604_c(entity);
        if (entity != null) {
            this.angerTargetUUID = entity.func_110124_au();
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return CreatureEntity.func_233666_p_().func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByAggressorGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new TargetAggressorGoal(this));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74777_a("Anger", (short)this.angerLevel);
        if (this.angerTargetUUID != null) {
            compound.func_74778_a("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.angerLevel = compound.func_74765_d("Anger");
        String hurtBy = compound.func_74779_i("HurtBy");
        if (!hurtBy.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(hurtBy);
            PlayerEntity entityplayer = this.field_70170_p.func_217371_b(this.angerTargetUUID);
            this.func_70604_c((LivingEntity)entityplayer);
            if (entityplayer != null) {
                this.field_70717_bb = entityplayer;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    protected void func_70619_bc() {
        ModifiableAttributeInstance attribute = this.func_110148_a(Attributes.field_233821_d_);
        if (this.isAngry()) {
            if (!this.func_70631_g_() && !attribute.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
                attribute.func_233767_b_(ATTACK_SPEED_BOOST_MODIFIER);
            }
            --this.angerLevel;
        } else if (attribute.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
            attribute.func_111124_b(ATTACK_SPEED_BOOST_MODIFIER);
        }
        if (this.angerLevel > 0 && this.angerTargetUUID != null && this.func_70643_av() == null) {
            PlayerEntity entityplayer = this.field_70170_p.func_217371_b(this.angerTargetUUID);
            this.func_70604_c((LivingEntity)entityplayer);
            this.field_70717_bb = entityplayer;
            this.field_70718_bc = this.func_142015_aE();
        }
        super.func_70619_bc();
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        Entity sourceEntity = damageSource.func_76346_g();
        if (sourceEntity instanceof PlayerEntity && !((PlayerEntity)sourceEntity).func_184812_l_() && this.func_70685_l(sourceEntity)) {
            this.becomeAngryAt(sourceEntity);
        }
        return super.func_70097_a(damageSource, amount);
    }

    private boolean becomeAngryAt(Entity target) {
        this.angerLevel = 400 + this.field_70146_Z.nextInt(400);
        if (target instanceof LivingEntity) {
            this.func_70604_c((LivingEntity)target);
        }
        return true;
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    protected SoundEvent func_184639_G() {
        return Sounds.IGGY_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return Sounds.IGGY_ATTACK;
    }

    protected SoundEvent func_184615_bR() {
        return Sounds.IGGY_DEATH;
    }

    static class HurtByAggressorGoal
    extends HurtByTargetGoal {
        public HurtByAggressorGoal(IguanaEntity iguana) {
            super((CreatureEntity)iguana, new Class[0]);
            this.func_220794_a(new Class[]{IguanaEntity.class});
        }

        protected void func_220793_a(MobEntity mob, LivingEntity target) {
            if (mob instanceof IguanaEntity && this.field_75299_d.func_70685_l((Entity)target) && ((IguanaEntity)mob).becomeAngryAt((Entity)target)) {
                mob.func_70624_b(target);
            }
        }
    }

    static class TargetAggressorGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public TargetAggressorGoal(IguanaEntity iggy) {
            super((MobEntity)iggy, PlayerEntity.class, true);
        }

        public boolean func_75250_a() {
            return ((IguanaEntity)this.field_75299_d).isAngry() && super.func_75250_a();
        }
    }
}

