/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.neutral;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeyAngryThrowGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeyFollowNearestPinaColadaHolderGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeyPickUpPinaColadaGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeySitAndDrinkGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeySitInChairGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeyStealDrinkGoal;
import net.tropicraft.core.common.item.CocktailItem;
import net.tropicraft.core.common.item.TropicraftItems;

public class VMonkeyEntity
extends TameableEntity {
    private static final DataParameter<Byte> DATA_FLAGS = EntityDataManager.func_187226_a(VMonkeyEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final int FLAG_CLIMBING = 1;
    public static final Predicate<LivingEntity> FOLLOW_PREDICATE = ent -> {
        if (ent == null) {
            return false;
        }
        if (!(ent instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)ent;
        ItemStack heldMain = player.func_184614_ca();
        ItemStack heldOff = player.func_184592_cb();
        if (heldMain.func_77973_b() instanceof CocktailItem && CocktailItem.getDrink(heldMain) == Drink.PINA_COLADA) {
            return true;
        }
        if (heldOff.func_77973_b() instanceof CocktailItem) {
            return CocktailItem.getDrink(heldOff) == Drink.PINA_COLADA;
        }
        return false;
    };
    private LivingEntity following;
    private boolean madAboutStolenAlcohol;

    public VMonkeyEntity(EntityType<? extends TameableEntity> type, World world) {
        super(type, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FLAGS, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return TameableEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MonkeyFollowNearestPinaColadaHolderGoal(this, 1.0, 2.0f, 10.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (Goal)new MonkeyPickUpPinaColadaGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MonkeyStealDrinkGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MonkeySitAndDrinkGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MonkeyAngryThrowGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MonkeySitInChairGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("MonkeyFlags", this.getMonkeyFlags());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setMonkeyFlags(compound.func_74771_c("MonkeyFlags"));
    }

    public LivingEntity getFollowing() {
        return this.following;
    }

    public void setFollowing(@Nullable LivingEntity following) {
        this.following = following;
    }

    public boolean selfHoldingDrink(Drink drink) {
        ItemStack heldItem = this.func_184614_ca();
        if (heldItem.func_77973_b() instanceof CocktailItem) {
            return CocktailItem.getDrink(heldItem) == drink;
        }
        return false;
    }

    private void setMonkeyFlags(byte flags) {
        this.func_184212_Q().func_187227_b(DATA_FLAGS, (Object)flags);
    }

    private byte getMonkeyFlags() {
        return (Byte)this.func_184212_Q().func_187225_a(DATA_FLAGS);
    }

    public boolean isClimbing() {
        return this.getMonkeyFlag(1);
    }

    private void setClimbing(boolean state) {
        this.setMonkeyFlag(1, state);
    }

    public void setMonkeyFlag(int id, boolean flag) {
        if (flag) {
            this.field_70180_af.func_187227_b(DATA_FLAGS, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS) | id)));
        } else {
            this.field_70180_af.func_187227_b(DATA_FLAGS, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS) & ~id)));
        }
    }

    private boolean getMonkeyFlag(int flag) {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS) & flag) != 0;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (this.func_152114_e((LivingEntity)player) && !this.field_70170_p.field_72995_K) {
                this.func_233687_w_(!this.func_233685_eM_());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_213395_q(false);
            }
        } else if (!stack.func_190926_b() && this.func_70877_b(stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70903_f(true);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.func_233687_w_(true);
                    this.func_70606_j(20.0f);
                    this.func_184754_b(player.func_110124_au());
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return ActionResultType.PASS;
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_70877_b(ItemStack stack) {
        return CocktailItem.getDrink(stack) == Drink.PINA_COLADA;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity entity) {
        return null;
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        return !this.func_70909_n() && target.func_200600_R() == EntityType.field_200729_aH;
    }

    public boolean func_70652_k(Entity entity) {
        boolean damaged = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
        if (damaged) {
            this.func_174815_a((LivingEntity)this, entity);
        }
        return damaged;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && entity.func_200600_R() != EntityType.field_200729_aH && !(entity instanceof ArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.V_MONKEY_SPAWN_EGG.get());
    }

    public boolean isMadAboutStolenAlcohol() {
        return this.madAboutStolenAlcohol;
    }

    public void setMadAboutStolenAlcohol(boolean madAboutStolenAlcohol) {
        this.madAboutStolenAlcohol = madAboutStolenAlcohol;
    }
}

