/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.ai.EntityAIAvoidEntityOnLowHealth;
import net.tropicraft.core.common.entity.ai.EntityAIChillAtFire;
import net.tropicraft.core.common.entity.ai.EntityAIEatToHeal;
import net.tropicraft.core.common.entity.ai.EntityAIGoneFishin;
import net.tropicraft.core.common.entity.ai.EntityAIKoaMate;
import net.tropicraft.core.common.entity.ai.EntityAIPartyTime;
import net.tropicraft.core.common.entity.ai.EntityAIPlayKoa;
import net.tropicraft.core.common.entity.ai.EntityAITemptHelmet;
import net.tropicraft.core.common.entity.ai.EntityAIWanderNotLazy;
import net.tropicraft.core.common.entity.passive.EntityKoaHunter;
import net.tropicraft.core.common.entity.passive.FishingBobberEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class EntityKoaBase
extends VillagerEntity {
    public long lastTimeFished = 0L;
    public BlockPos posLastFireplaceFound = null;
    public List<BlockPos> listPosDrums = new ArrayList<BlockPos>();
    public static int MAX_DRUMS = 12;
    public Inventory inventory;
    private static final DataParameter<Integer> ROLE = EntityDataManager.func_187226_a(EntityKoaBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> GENDER = EntityDataManager.func_187226_a(EntityKoaBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ORIENTATION = EntityDataManager.func_187226_a(EntityKoaBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityKoaBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DANCING = EntityDataManager.func_187226_a(EntityKoaBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> LURE_ID = EntityDataManager.func_187226_a(EntityKoaBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final Goal taskFishing = new EntityAIGoneFishin(this);
    private float clientHealthLastTracked = 0.0f;
    public static int MAX_HOME_DISTANCE = 128;
    private int villageID = -1;
    private RegistryKey<World> villageDimension;
    private FishingBobberEntity lure;
    private boolean wasInWater = false;
    private boolean wasNightLastTick = false;
    private boolean wantsToParty = false;
    public boolean jumpingOutOfWater = false;
    public int hitIndex = 0;
    public int hitIndex2 = 0;
    public int hitIndex3 = 0;
    public int hitDelay = 0;
    private long lastTradeTime = 0L;
    private static final int TRADE_COOLDOWN = 72000;
    private static final int DIVE_TIME_NEEDED = 3600;
    public boolean debug = false;
    public int druggedTime = 0;
    private static final Set<RegistryObject<Item>> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new RegistryObject[]{TropicraftItems.NIGEL_STACHE});
    private boolean isMating;
    private boolean isPlaying;
    private boolean finalizedSpawn;
    public static com.google.common.base.Predicate<Entity> ENEMY_PREDICATE = input -> input instanceof MonsterEntity;

    public EntityKoaBase(EntityType<? extends EntityKoaBase> type, World worldIn) {
        super(type, worldIn);
        this.func_110163_bv();
        this.inventory = new Inventory(9);
    }

    public boolean func_230279_az_() {
        return true;
    }

    public long getLastTradeTime() {
        return this.lastTradeTime;
    }

    public void setLastTradeTime(long lastTradeTime) {
        this.lastTradeTime = lastTradeTime;
    }

    public Genders getGender() {
        return Genders.get((Integer)this.func_184212_Q().func_187225_a(GENDER));
    }

    public void setGender(Genders gender) {
        this.func_184212_Q().func_187227_b(GENDER, (Object)gender.ordinal());
    }

    public Roles getRole() {
        return Roles.get((Integer)this.func_184212_Q().func_187225_a(ROLE));
    }

    public Orientations getOrientation() {
        return Orientations.get((Integer)this.func_184212_Q().func_187225_a(ORIENTATION));
    }

    public boolean isSitting() {
        return (Boolean)this.func_184212_Q().func_187225_a(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.func_184212_Q().func_187227_b(SITTING, (Object)sitting);
    }

    public boolean isDancing() {
        return (Boolean)this.func_184212_Q().func_187225_a(DANCING);
    }

    public void setDancing(boolean val) {
        this.func_184212_Q().func_187227_b(DANCING, (Object)val);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ROLE, (Object)0);
        this.func_184212_Q().func_187214_a(GENDER, (Object)0);
        this.func_184212_Q().func_187214_a(ORIENTATION, (Object)0);
        this.func_184212_Q().func_187214_a(SITTING, (Object)false);
        this.func_184212_Q().func_187214_a(DANCING, (Object)false);
        this.func_184212_Q().func_187214_a(LURE_ID, (Object)-1);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        if (key == LURE_ID) {
            int id = (Integer)this.func_184212_Q().func_187225_a(LURE_ID);
            if (id != -1) {
                this.scheduleEntityLookup(this, id);
            } else {
                this.setLure(null);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void scheduleEntityLookup(EntityKoaBase koa, int id) {
        Minecraft.func_71410_x().execute(() -> {
            Entity ent = this.field_70170_p.func_73045_a(id);
        });
    }

    protected void func_184651_r() {
    }

    public Int2ObjectMap<VillagerTrades.ITrade[]> getOfferMap() {
        Int2ObjectMap<VillagerTrades.ITrade[]> offers = null;
        if (this.getRole() == Roles.FISHERMAN) {
            offers = EntityKoaBase.toIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new KoaTradeForPearls((IItemProvider)Items.field_196088_aY, 20, 8, 2), new KoaTradeForPearls((IItemProvider)TropicraftItems.FISHING_NET.get(), 1, 8, 2), new KoaTradeForPearls((IItemProvider)Items.field_151112_aM, 1, 8, 2), new KoaTradeForPearls((IItemProvider)TropicraftItems.FRESH_MARLIN.get(), 3, 8, 2), new KoaTradeForPearls((IItemProvider)TropicraftItems.SARDINE_BUCKET.get(), 1, 4, 2), new KoaTradeForPearls((IItemProvider)TropicraftItems.PIRANHA_BUCKET.get(), 1, 3, 2), new KoaTradeForPearls((IItemProvider)TropicraftItems.TROPICAL_FERTILIZER.get(), 5, 8, 2)}));
        } else if (this.getRole() == Roles.HUNTER) {
            offers = EntityKoaBase.toIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new KoaTradeForPearls((IItemProvider)TropicraftItems.FROG_LEG.get(), 5, 8, 2), new KoaTradeForPearls((IItemProvider)TropicraftItems.IGUANA_LEATHER.get(), 2, 8, 2), new KoaTradeForPearls((IItemProvider)TropicraftItems.SCALE.get(), 5, 8, 2)}));
        }
        return offers;
    }

    private static Int2ObjectMap<VillagerTrades.ITrade[]> toIntMap(ImmutableMap<Integer, VillagerTrades.ITrade[]> p_221238_0_) {
        return new Int2ObjectOpenHashMap(p_221238_0_);
    }

    protected void func_213712_ef() {
        VillagerTrades.ITrade[] avillagertrades$itrade;
        VillagerData villagerdata = this.func_213700_eh();
        Int2ObjectMap<VillagerTrades.ITrade[]> int2objectmap = this.getOfferMap();
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades$itrade = (VillagerTrades.ITrade[])int2objectmap.get(villagerdata.func_221132_c())) != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.func_213717_a(merchantoffers, avillagertrades$itrade, 2);
        }
    }

    public void updateUniqueEntityAI() {
        this.field_70714_bg.func_220888_c().forEach(PrioritizedGoal::func_75251_c);
        this.field_70715_bh.func_220888_c().forEach(PrioritizedGoal::func_75251_c);
        int curPri = 0;
        this.field_70714_bg.func_75776_a(curPri++, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(curPri++, new EntityAIAvoidEntityOnLowHealth<LivingEntity>((CreatureEntity)this, LivingEntity.class, (Predicate<Entity>)ENEMY_PREDICATE, 12.0f, 1.4, 1.4, 15.0f));
        this.field_70714_bg.func_75776_a(curPri++, (Goal)new EntityAIEatToHeal(this));
        this.field_70714_bg.func_75776_a(curPri++, (Goal)new TradeWithPlayerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(curPri++, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true){

            public void func_75249_e() {
                super.func_75249_e();
                if (this.field_75441_b instanceof EntityKoaBase) {
                    ((EntityKoaBase)this.field_75441_b).setFightingItem();
                }
            }

            protected double func_179512_a(LivingEntity attackTarget) {
                return this.field_75441_b.func_200600_R().func_220334_j().field_220315_a * 2.5f * this.field_75441_b.func_200600_R().func_220334_j().field_220315_a * 2.5f + attackTarget.func_200600_R().func_220334_j().field_220315_a;
            }
        });
        this.field_70714_bg.func_75776_a(curPri++, (Goal)new EntityAITemptHelmet((CreatureEntity)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(curPri++, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(curPri++, (Goal)new EntityAIKoaMate(this));
        this.field_70714_bg.func_75776_a(curPri++, (Goal)new EntityAIChillAtFire(this));
        this.field_70714_bg.func_75776_a(curPri++, (Goal)new EntityAIPartyTime(this));
        if (this.canFish()) {
            this.field_70714_bg.func_75776_a(curPri++, this.taskFishing);
        }
        if (this.func_70631_g_()) {
            this.field_70714_bg.func_75776_a(curPri++, (Goal)new EntityAIPlayKoa(this, 1.2));
        }
        this.field_70714_bg.func_75776_a(curPri, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(curPri++, (Goal)new EntityAIWanderNotLazy((CreatureEntity)this, 1.0, 40));
        this.field_70714_bg.func_75776_a(curPri++, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        if (this.canHunt()) {
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, true, false, ENEMY_PREDICATE));
        }
    }

    public VillagerEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        EntityKoaHunter child = new EntityKoaHunter((EntityType<? extends EntityKoaHunter>)((EntityType)TropicraftEntities.KOA_HUNTER.get()), this.field_70170_p);
        child.func_213386_a((IServerWorld)world, world.func_175649_E(child.func_233580_cy_()), SpawnReason.BREEDING, null, null);
        return child;
    }

    protected void func_175500_n() {
        super.func_175500_n();
        this.updateUniqueEntityAI();
    }

    public boolean canFish() {
        return ((Integer)this.func_184212_Q().func_187225_a(ROLE)).intValue() == Roles.FISHERMAN.ordinal();
    }

    public boolean canHunt() {
        return ((Integer)this.func_184212_Q().func_187225_a(ROLE)).intValue() == Roles.HUNTER.ordinal() && !this.func_70631_g_();
    }

    public void setHunter() {
        this.func_184212_Q().func_187227_b(ROLE, (Object)Roles.HUNTER.ordinal());
        this.setFightingItem();
    }

    public void setFisher() {
        this.func_184212_Q().func_187227_b(ROLE, (Object)Roles.FISHERMAN.ordinal());
        this.setFishingItem();
    }

    protected void func_70619_bc() {
        this.monitorHomeVillage();
        this.findAndSetHomeToCloseChest(false);
        this.findAndSetFireSource(false);
        this.findAndSetDrums(false);
        this.findAndSetTownID(false);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return VillagerEntity.func_234551_eU_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float damage = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        float knockback = (float)this.func_233637_b_(Attributes.field_233824_g_);
        if (entityIn instanceof LivingEntity) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            knockback += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage)) {
            int j;
            if (knockback > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_233627_a_(knockback * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213293_j(this.func_213322_ci().field_72450_a * 0.6, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c * 0.6);
            }
            if ((j = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof PlayerEntity) {
                ItemStack itemstack1;
                PlayerEntity entityplayer = (PlayerEntity)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b() instanceof AxeItem && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (hand != Hand.MAIN_HAND) {
            return ActionResultType.PASS;
        }
        ActionResultType ret = ActionResultType.PASS;
        try {
            boolean doTrade = true;
            if (!this.field_70170_p.field_72995_K) {
                ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
                if (!stack.func_190926_b() && stack.func_77973_b() == TropicraftItems.POISON_FROG_SKIN.get()) {
                    doTrade = false;
                    this.dbg("koa drugged, zapping memory");
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    this.zapMemory();
                    this.druggedTime += 2400;
                    this.func_195064_c(new EffectInstance(Effects.field_76431_k, this.druggedTime));
                    this.findAndSetDrums(true);
                }
                if (doTrade) {
                    ret = super.func_230254_b_(player, hand);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return null;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_213390_a(this.func_233580_cy_(), MAX_HOME_DISTANCE);
        this.rollDiceChild();
        this.rollDiceRole();
        this.rollDiceGender();
        this.rollDiceOrientation();
        this.updateUniqueEntityAI();
        this.finalizedSpawn = true;
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void rollDiceChild() {
        int childChance = 20;
        if (childChance >= this.field_70170_p.field_73012_v.nextInt(100)) {
            this.func_70873_a(-24000);
        }
    }

    public void rollDiceRole() {
        int randValRole = this.field_70170_p.field_73012_v.nextInt(Roles.values().length);
        if (randValRole == Roles.FISHERMAN.ordinal()) {
            this.setFisher();
        } else if (randValRole == Roles.HUNTER.ordinal()) {
            this.setHunter();
        }
    }

    public void rollDiceGender() {
        int randValGender = this.field_70170_p.field_73012_v.nextInt(Genders.values().length);
        this.func_184212_Q().func_187227_b(GENDER, (Object)randValGender);
    }

    public void rollDiceOrientation() {
        this.func_184212_Q().func_187227_b(ORIENTATION, (Object)Orientations.STRAIT.ordinal());
        int chance = 5;
        if (chance >= this.field_70170_p.field_73012_v.nextInt(100)) {
            this.func_184212_Q().func_187227_b(ORIENTATION, (Object)Orientations.GAY.ordinal());
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        int i;
        super.func_213281_b(compound);
        compound.func_74768_a("home_X", this.func_213384_dI().func_177958_n());
        compound.func_74768_a("home_Y", this.func_213384_dI().func_177956_o());
        compound.func_74768_a("home_Z", this.func_213384_dI().func_177952_p());
        if (this.posLastFireplaceFound != null) {
            compound.func_74768_a("fireplace_X", this.posLastFireplaceFound.func_177958_n());
            compound.func_74768_a("fireplace_Y", this.posLastFireplaceFound.func_177956_o());
            compound.func_74768_a("fireplace_Z", this.posLastFireplaceFound.func_177952_p());
        }
        compound.func_74772_a("lastTimeFished", this.lastTimeFished);
        ListNBT nbttaglist = new ListNBT();
        for (i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        compound.func_218657_a("koa_inventory", (INBT)nbttaglist);
        compound.func_74768_a("role_id", ((Integer)this.func_184212_Q().func_187225_a(ROLE)).intValue());
        compound.func_74768_a("gender_id", ((Integer)this.func_184212_Q().func_187225_a(GENDER)).intValue());
        compound.func_74768_a("orientation_id", ((Integer)this.func_184212_Q().func_187225_a(ORIENTATION)).intValue());
        compound.func_74768_a("village_id", this.villageID);
        if (this.villageDimension != null) {
            compound.func_74778_a("village_dimension", this.villageDimension.func_240901_a_().toString());
        }
        compound.func_74772_a("lastTradeTime", this.lastTradeTime);
        for (i = 0; i < this.listPosDrums.size(); ++i) {
            compound.func_74768_a("drum_" + i + "_X", this.listPosDrums.get(i).func_177958_n());
            compound.func_74768_a("drum_" + i + "_Y", this.listPosDrums.get(i).func_177956_o());
            compound.func_74768_a("drum_" + i + "_Z", this.listPosDrums.get(i).func_177952_p());
        }
        compound.func_74768_a("druggedTime", this.druggedTime);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("home_X")) {
            this.func_213390_a(new BlockPos(compound.func_74762_e("home_X"), compound.func_74762_e("home_Y"), compound.func_74762_e("home_Z")), MAX_HOME_DISTANCE);
        }
        if (compound.func_74764_b("fireplace_X")) {
            this.setFirelacePos(new BlockPos(compound.func_74762_e("fireplace_X"), compound.func_74762_e("fireplace_Y"), compound.func_74762_e("fireplace_Z")));
        }
        this.lastTimeFished = compound.func_74763_f("lastTimeFished");
        if (compound.func_150297_b("koa_inventory", 9)) {
            ListNBT nbttaglist = compound.func_150295_c("koa_inventory", 10);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundNBT nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                this.inventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)nbttagcompound));
            }
        }
        this.villageID = compound.func_74762_e("village_id");
        this.villageDimension = !compound.func_74764_b("village_dimension") ? this.field_70170_p.func_234923_W_() : RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compound.func_74779_i("village_dim_id")));
        if (compound.func_74764_b("role_id")) {
            this.func_184212_Q().func_187227_b(ROLE, (Object)compound.func_74762_e("role_id"));
        } else {
            this.rollDiceRole();
        }
        if (compound.func_74764_b("gender_id")) {
            this.func_184212_Q().func_187227_b(GENDER, (Object)compound.func_74762_e("gender_id"));
        } else {
            this.rollDiceGender();
        }
        if (compound.func_74764_b("orientation_id")) {
            this.func_184212_Q().func_187227_b(ORIENTATION, (Object)compound.func_74762_e("orientation_id"));
        } else {
            this.rollDiceOrientation();
        }
        this.lastTradeTime = compound.func_74763_f("lastTradeTime");
        for (int i = 0; i < MAX_DRUMS; ++i) {
            if (!compound.func_74764_b("drum_" + i + "_X")) continue;
            this.listPosDrums.add(new BlockPos(compound.func_74762_e("drum_" + i + "_X"), compound.func_74762_e("drum_" + i + "_Y"), compound.func_74762_e("drum_" + i + "_Z")));
        }
        this.druggedTime = compound.func_74762_e("druggedTime");
        this.updateUniqueEntityAI();
    }

    public void setFishingItem() {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151112_aM));
    }

    public void setFightingItem() {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)TropicraftItems.DAGGER.get()));
    }

    public void monitorHomeVillage() {
        if (this.villageDimension != null && this.field_70170_p.func_234923_W_() != this.villageDimension) {
            this.dbg("koa detected different dimension, zapping memory");
            this.zapMemory();
            this.func_195064_c(new EffectInstance(Effects.field_76421_d, 5));
        }
    }

    public void findAndSetHomeToCloseChest(boolean force) {
        if (!force && (this.field_70170_p.func_82737_E() + (long)this.func_145782_y()) % 600L != 0L) {
            return;
        }
        boolean tryFind = false;
        if (this.func_213384_dI() == null) {
            tryFind = true;
        } else {
            TileEntity tile = this.field_70170_p.func_175625_s(this.func_213384_dI());
            if (!(tile instanceof ChestTileEntity)) {
                tryFind = true;
            }
        }
        if (tryFind) {
            int range = 20;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range / 2; y <= range / 2; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos pos = this.func_233580_cy_().func_177982_a(x, y, z);
                        TileEntity tile = this.field_70170_p.func_175625_s(pos);
                        if (!(tile instanceof ChestTileEntity)) continue;
                        this.dbg("found chest, updating home position to " + pos);
                        this.func_213390_a(pos, MAX_HOME_DISTANCE);
                        return;
                    }
                }
            }
        }
    }

    public boolean findAndSetTownID(boolean force) {
        if (!force && (this.field_70170_p.func_82737_E() + (long)this.func_145782_y()) % 600L != 0L) {
            return false;
        }
        boolean tryFind = false;
        if (this.villageID == -1 || this.villageDimension == null) {
            tryFind = true;
            this.villageID = -1;
        }
        if (tryFind) {
            List listEnts = this.field_70170_p.func_217357_a(EntityKoaBase.class, new AxisAlignedBB(this.func_233580_cy_()).func_72314_b(20.0, 20.0, 20.0));
            Collections.shuffle(listEnts);
            for (EntityKoaBase ent : listEnts) {
                if (ent.villageID == -1 || ent.villageDimension == null) continue;
                this.setVillageAndDimID(ent.villageID, ent.villageDimension);
                break;
            }
        }
        return this.villageID != -1;
    }

    public void findAndSetFireSource(boolean force) {
        BlockState state;
        if (!force && (this.field_70170_p.func_82737_E() + (long)this.func_145782_y()) % 600L != 0L) {
            return;
        }
        boolean tryFind = false;
        if (this.posLastFireplaceFound == null) {
            tryFind = true;
        } else if (this.posLastFireplaceFound != null && (state = this.field_70170_p.func_180495_p(this.posLastFireplaceFound)).func_177230_c() != Blocks.field_222433_lV) {
            this.posLastFireplaceFound = null;
            tryFind = true;
        }
        if (tryFind) {
            int range = 20;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range / 2; y <= range / 2; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos pos = this.func_233580_cy_().func_177982_a(x, y, z);
                        BlockState state2 = this.field_70170_p.func_180495_p(pos);
                        if (state2.func_177230_c() != Blocks.field_222433_lV) continue;
                        this.dbg("found fire place spot to chill");
                        this.setFirelacePos(pos);
                        return;
                    }
                }
            }
            List listEnts = this.field_70170_p.func_217357_a(EntityKoaBase.class, new AxisAlignedBB(this.func_233580_cy_()).func_72314_b(20.0, 20.0, 20.0));
            Collections.shuffle(listEnts);
            for (EntityKoaBase ent : listEnts) {
                BlockState state3;
                if (ent.posLastFireplaceFound == null || (state3 = this.field_70170_p.func_180495_p(ent.posLastFireplaceFound)).func_177230_c() != Blocks.field_222433_lV) continue;
                this.posLastFireplaceFound = new BlockPos((Vector3i)ent.posLastFireplaceFound);
                this.dbg("found fire place spot to chill from entity");
                return;
            }
        }
    }

    public void syncBPM() {
        if ((this.field_70170_p.func_82737_E() + (long)this.func_145782_y()) % 20L != 0L) {
            return;
        }
        List listEnts = this.field_70170_p.func_217357_a(EntityKoaBase.class, new AxisAlignedBB(this.func_233580_cy_()).func_72314_b(10.0, 5.0, 10.0));
        for (EntityKoaBase ent : listEnts) {
            if (this.hitDelay == ent.hitDelay) continue;
            this.hitDelay = ent.hitDelay;
            this.hitIndex = ent.hitIndex;
            this.hitIndex2 = ent.hitIndex2;
            this.hitIndex3 = ent.hitIndex3;
            return;
        }
    }

    public boolean isInstrument(BlockPos pos) {
        BlockState state = this.field_70170_p.func_180495_p(pos);
        return state.func_177230_c().func_203417_a(TropicraftTags.Blocks.BONGOS) || state.func_177230_c() == Blocks.field_196586_al;
    }

    public void findAndSetDrums(boolean force) {
        if (!force && (this.field_70170_p.func_82737_E() + (long)this.func_145782_y()) % 600L != 0L) {
            return;
        }
        Iterator<BlockPos> it = this.listPosDrums.iterator();
        while (it.hasNext()) {
            BlockPos pos = it.next();
            if (this.isInstrument(pos)) continue;
            it.remove();
        }
        if (this.listPosDrums.size() >= MAX_DRUMS) {
            return;
        }
        List listEnts = this.field_70170_p.func_217357_a(EntityKoaBase.class, new AxisAlignedBB(this.func_233580_cy_()).func_72314_b(20.0, 20.0, 20.0));
        Collections.shuffle(listEnts);
        for (EntityKoaBase ent : listEnts) {
            if (this.listPosDrums.size() >= MAX_DRUMS) {
                return;
            }
            for (BlockPos pos : ent.listPosDrums) {
                boolean match = false;
                for (BlockPos pos2 : this.listPosDrums) {
                    if (!pos.equals((Object)pos2)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    this.listPosDrums.add(pos);
                }
                if (this.listPosDrums.size() < MAX_DRUMS) continue;
                return;
            }
        }
        int range = 20;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range / 2; y <= range / 2; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos pos = this.func_233580_cy_().func_177982_a(x, y, z);
                    if (!this.isInstrument(pos)) continue;
                    boolean match = false;
                    for (BlockPos pos2 : this.listPosDrums) {
                        if (!pos.equals((Object)pos2)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        this.listPosDrums.add(pos);
                    }
                    if (this.listPosDrums.size() < MAX_DRUMS) continue;
                    return;
                }
            }
        }
    }

    public boolean tryDumpInventoryIntoHomeChest() {
        TileEntity tile = this.field_70170_p.func_175625_s(this.func_213384_dI());
        if (tile instanceof ChestTileEntity) {
            ChestTileEntity chest = (ChestTileEntity)tile;
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.inventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(i, this.addItem(chest, itemstack));
            }
        }
        return true;
    }

    @Nullable
    public ItemStack addItem(ChestTileEntity chest, ItemStack stack) {
        ItemStack itemstack = stack.func_77946_l();
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            ItemStack itemstack1 = chest.func_70301_a(i);
            if (itemstack1.func_190926_b()) {
                chest.func_70299_a(i, itemstack);
                chest.func_70296_d();
                return ItemStack.field_190927_a;
            }
            if (!ItemStack.func_179545_c((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            int j = Math.min(chest.func_70297_j_(), itemstack1.func_77976_d());
            int k = Math.min(itemstack.func_190916_E(), j - itemstack1.func_190916_E());
            if (k <= 0) continue;
            itemstack1.func_190917_f(k);
            itemstack.func_190918_g(k);
            if (itemstack.func_190916_E() > 0) continue;
            chest.func_70296_d();
            return ItemStack.field_190927_a;
        }
        if (itemstack.func_190916_E() != stack.func_190916_E()) {
            chest.func_70296_d();
        }
        return itemstack;
    }

    public void setFirelacePos(BlockPos pos) {
        this.posLastFireplaceFound = pos;
    }

    public int func_70086_ai() {
        return super.func_70086_ai();
    }

    public void func_70636_d() {
        if (this.finalizedSpawn) {
            this.finalizedSpawn = false;
            this.findAndSetHomeToCloseChest(true);
            this.findAndSetFireSource(true);
            this.findAndSetDrums(true);
        }
        this.func_82168_bl();
        super.func_70636_d();
        if (this.wasInWater && !this.func_70090_H() && this.field_70123_F) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)0.4f, 0.0));
            this.jumpingOutOfWater = true;
        }
        if (this.jumpingOutOfWater && this.field_70122_E) {
            this.jumpingOutOfWater = false;
            this.func_70661_as().func_75499_g();
        }
        if (this.func_70090_H()) {
            if (this.func_70631_g_()) {
                if (this.func_213322_ci().field_72448_b < (double)-0.1f) {
                    this.func_213322_ci().func_72441_c(0.0, 0.25, 0.0);
                }
            } else if (this.func_213322_ci().field_72448_b < (double)-0.2f) {
                this.func_213322_ci().func_72441_c(0.0, (double)0.15f, 0.0);
            }
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.6);
            this.func_184644_a(PathNodeType.WATER, 8.0f);
        } else {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.28);
            this.func_184644_a(PathNodeType.WATER, -1.0f);
        }
        this.wasInWater = this.func_70090_H();
        if (!this.wasNightLastTick && !this.field_70170_p.func_72935_r()) {
            this.rollDiceParty();
        }
        boolean bl = this.wasNightLastTick = !this.field_70170_p.func_72935_r();
        if (!this.field_70170_p.field_72995_K && this.druggedTime > 0) {
            --this.druggedTime;
        }
        if (this.field_70170_p.field_72995_K && this.clientHealthLastTracked != this.func_110143_aJ()) {
            if (this.func_110143_aJ() > this.clientHealthLastTracked) {
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197633_z, false, this.func_226277_ct_(), this.func_226278_cu_() + 2.2, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            this.clientHealthLastTracked = this.func_110143_aJ();
        }
    }

    public void func_70691_i(float healAmount) {
        super.func_70691_i(healAmount);
    }

    public void setMating(boolean mating) {
        this.isMating = mating;
    }

    public boolean isMating() {
        return this.isMating;
    }

    public boolean getIsWillingToMate(boolean updateFirst) {
        this.setIsWillingToMate(true);
        return true;
    }

    public void setIsWillingToMate(boolean b) {
    }

    public boolean willBone(EntityKoaBase bonie) {
        EntityKoaBase boner = this;
        if (!bonie.getIsWillingToMate(true)) {
            return false;
        }
        if (boner.func_70631_g_() || bonie.func_70631_g_()) {
            return false;
        }
        if (boner.getOrientation() == Orientations.STRAIT) {
            return boner.getGender() != bonie.getGender();
        }
        if (boner.getOrientation() == Orientations.GAY) {
            return boner.getGender() == bonie.getGender();
        }
        return true;
    }

    public int getVillageID() {
        return this.villageID;
    }

    public void setVillageAndDimID(int villageID, RegistryKey<World> villageDimID) {
        this.villageID = villageID;
        this.villageDimension = villageDimID;
    }

    public RegistryKey<World> getVillageDimension() {
        return this.villageDimension;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    public void hookUnloaded() {
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    public FishingBobberEntity getLure() {
        return this.lure;
    }

    public void setLure(FishingBobberEntity lure) {
        this.lure = lure;
        if (!this.field_70170_p.field_72995_K) {
            if (lure != null) {
                this.func_184212_Q().func_187227_b(LURE_ID, (Object)this.lure.func_145782_y());
            } else {
                this.func_184212_Q().func_187227_b(LURE_ID, (Object)-1);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean result = super.func_70097_a(source, amount);
        if (!(this.func_110143_aJ() <= 0.0f) || source.func_76346_g() instanceof LivingEntity) {
            // empty if block
        }
        return result;
    }

    public boolean isPartyNight() {
        long time = this.field_70170_p.func_72820_D();
        long day = time / 24000L;
        return day % 3L == 0L;
    }

    public void rollDiceParty() {
        int chance;
        if (this.isPartyNight() && (chance = 90) >= this.field_70170_p.field_73012_v.nextInt(100)) {
            this.wantsToParty = true;
            return;
        }
        this.wantsToParty = false;
    }

    public boolean getWantsToParty() {
        return this.wantsToParty;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("entity.tropicraft.koa." + this.getGender().toString().toLowerCase(Locale.ROOT) + "." + this.getRole().toString().toLowerCase(Locale.ROOT) + ".name");
    }

    public void func_241841_a(ServerWorld world, LightningBoltEntity lightning) {
    }

    public void zapMemory() {
        this.listPosDrums.clear();
        this.func_213390_a(BlockPos.field_177992_a, -1);
        this.setFirelacePos(null);
        this.villageDimension = null;
        this.villageID = -1;
    }

    public void dbg(String msg) {
        if (this.debug) {
            System.out.println(msg);
        }
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (soundIn == SoundEvents.field_187915_go || soundIn == SoundEvents.field_187913_gm) {
            return;
        }
        super.func_184185_a(soundIn, volume, pitch);
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.KOA_SPAWN_EGG.get());
    }

    static class KoaTradeForPearls
    implements VillagerTrades.ITrade {
        private final Item item;
        private final int count;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;

        public KoaTradeForPearls(IItemProvider item, int count, int maxUses, int givenXP) {
            this.item = item.func_199767_j();
            this.count = count;
            this.maxUses = maxUses;
            this.givenXP = givenXP;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity entity, Random random) {
            ItemStack itemstack = new ItemStack((IItemProvider)this.item, this.count);
            return new MerchantOffer(itemstack, new ItemStack((IItemProvider)TropicraftItems.WHITE_PEARL.get()), this.maxUses, this.givenXP, this.priceMultiplier);
        }
    }

    public static enum Orientations {
        STRAIT,
        GAY;

        private static final Map<Integer, Orientations> lookup;

        public static Orientations get(int intValue) {
            return lookup.get(intValue);
        }

        static {
            lookup = new HashMap<Integer, Orientations>();
            for (Orientations e : EnumSet.allOf(Orientations.class)) {
                lookup.put(e.ordinal(), e);
            }
        }
    }

    public static enum Roles {
        HUNTER,
        FISHERMAN;

        private static final Map<Integer, Roles> lookup;

        public static Roles get(int intValue) {
            return lookup.get(intValue);
        }

        static {
            lookup = new HashMap<Integer, Roles>();
            for (Roles e : EnumSet.allOf(Roles.class)) {
                lookup.put(e.ordinal(), e);
            }
        }
    }

    public static enum Genders {
        MALE,
        FEMALE;

        private static final Map<Integer, Genders> lookup;

        public static Genders get(int intValue) {
            return lookup.get(intValue);
        }

        static {
            lookup = new HashMap<Integer, Genders>();
            for (Genders e : EnumSet.allOf(Genders.class)) {
                lookup.put(e.ordinal(), e);
            }
        }
    }
}

