/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.item.TropicraftItems;

public class FailgullEntity
extends AnimalEntity
implements IFlyingAnimal {
    private boolean isFlockLeader;
    private static final DataParameter<Optional<UUID>> FLOCK_LEADER_UUID = EntityDataManager.func_187226_a(FailgullEntity.class, (IDataSerializer)DataSerializers.field_187203_m);

    public FailgullEntity(EntityType<? extends FailgullEntity> type, World world) {
        super(type, world);
        this.field_70728_aV = 1;
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 5, true);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return AnimalEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 3.0).func_233815_a_(Attributes.field_233821_d_, 0.6).func_233815_a_(Attributes.field_233822_e_, 0.9).func_233815_a_(Attributes.field_233819_b_, 12.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLOCK_LEADER_UUID, Optional.empty());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.isFlockLeader = nbt.func_74767_n("IsFlockLeader");
        if (nbt.func_74764_b("FlockLeader")) {
            this.setFlockLeader(Optional.of(nbt.func_186857_a("FlockLeader")));
        } else {
            this.setFlockLeader(Optional.empty());
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("IsFlockLeader", this.isFlockLeader);
        ((Optional)this.field_70180_af.func_187225_a(FLOCK_LEADER_UUID)).ifPresent(uuid -> nbt.func_186854_a("FlockLeader", uuid));
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos).func_196958_f() ? 10.0f : 0.0f;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new ValidateFlockLeader(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SelectFlockLeader(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SetTravelDestination());
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowLeaderGoal());
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.5f;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected boolean func_191957_ae() {
        return false;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn){

            public boolean func_188555_b(BlockPos pos) {
                return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
            }
        };
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    private void poop() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextInt(20) == 0) {
            SnowballEntity s = new SnowballEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            s.func_70186_c(0.0, 0.0, 0.0, 0.0f, 0.0f);
            this.field_70170_p.func_217376_c((Entity)s);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity partner) {
        return null;
    }

    private void setIsFlockLeader(boolean isFlockLeader) {
        this.isFlockLeader = isFlockLeader;
    }

    private void setFlockLeader(Optional<UUID> flockLeaderUUID) {
        this.field_70180_af.func_187227_b(FLOCK_LEADER_UUID, flockLeaderUUID);
    }

    private boolean getIsFlockLeader() {
        return this.isFlockLeader;
    }

    private boolean hasFlockLeader() {
        return ((Optional)this.field_70180_af.func_187225_a(FLOCK_LEADER_UUID)).isPresent();
    }

    @Nullable
    private Entity getFlockLeader() {
        if (this.field_70170_p instanceof ServerWorld && this.hasFlockLeader()) {
            return ((ServerWorld)this.field_70170_p).func_217461_a((UUID)((Optional)this.field_70180_af.func_187225_a(FLOCK_LEADER_UUID)).get());
        }
        return null;
    }

    @Nullable
    private BlockPos getRandomLocation() {
        Random random = this.func_70681_au();
        for (int i = 0; i < 20; ++i) {
            double nextZPos;
            double nextYPos;
            double nextXPos = this.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 48.0f);
            BlockPos pos = new BlockPos(nextXPos, nextYPos = this.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 3.0f), nextZPos = this.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 48.0f));
            if (!this.field_70170_p.func_175623_d(pos)) continue;
            return pos;
        }
        Vector3d Vector3d2 = this.func_70676_i(0.0f);
        Vector3d Vector3d22 = RandomPositionGenerator.func_226340_a_((CreatureEntity)this, (int)40, (int)3, (Vector3d)Vector3d2, (float)1.5707964f, (int)2, (int)1);
        Vector3d groundTarget = RandomPositionGenerator.func_226338_a_((CreatureEntity)this, (int)40, (int)4, (int)-2, (Vector3d)Vector3d2, (double)1.5707963705062866);
        return Vector3d22 != null ? new BlockPos(Vector3d22) : (groundTarget != null ? new BlockPos(groundTarget) : null);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.FAILGULL_SPAWN_EGG.get());
    }

    private static class SelectFlockLeader
    extends Goal {
        final FailgullEntity mob;

        public SelectFlockLeader(FailgullEntity failgullEntity) {
            this.mob = failgullEntity;
        }

        public boolean func_75250_a() {
            return !this.mob.hasFlockLeader();
        }

        public void func_75249_e() {
            List list = this.mob.field_70170_p.func_217357_a(FailgullEntity.class, this.mob.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0));
            list.remove((Object)this.mob);
            Optional<FailgullEntity> oldest = list.stream().min(Comparator.comparingInt(Entity::func_145782_y));
            if (oldest.isPresent() && !oldest.get().field_96093_i.equals(this.mob.func_110124_au())) {
                FailgullEntity oldestFailgull = oldest.get();
                oldestFailgull.setIsFlockLeader(true);
                oldestFailgull.setFlockLeader(Optional.empty());
                this.mob.setIsFlockLeader(false);
                this.mob.setFlockLeader(Optional.of(oldestFailgull.func_110124_au()));
            }
        }
    }

    private static class ValidateFlockLeader
    extends Goal {
        final FailgullEntity mob;

        public ValidateFlockLeader(FailgullEntity failgullEntity) {
            this.mob = failgullEntity;
        }

        public boolean func_75250_a() {
            if (this.mob.getIsFlockLeader()) {
                return false;
            }
            Entity flockLeader = this.mob.getFlockLeader();
            return flockLeader == null || !flockLeader.func_70089_S();
        }

        public void func_75249_e() {
            this.mob.setFlockLeader(Optional.empty());
        }
    }

    class SetTravelDestination
    extends Goal {
        SetTravelDestination() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        private boolean shouldLead() {
            return FailgullEntity.this.getIsFlockLeader() || !FailgullEntity.this.hasFlockLeader();
        }

        public boolean func_75250_a() {
            return this.shouldLead() && FailgullEntity.this.func_70661_as().func_75500_f() && FailgullEntity.this.func_70681_au().nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return this.shouldLead() && FailgullEntity.this.func_70661_as().func_226337_n_();
        }

        public void func_75249_e() {
            BlockPos Vector3d2 = FailgullEntity.this.getRandomLocation();
            if (Vector3d2 != null) {
                PathNavigator navigator = FailgullEntity.this.func_70661_as();
                navigator.func_75484_a(navigator.func_179680_a(Vector3d2, 1), 1.0);
            }
        }
    }

    class FollowLeaderGoal
    extends Goal {
        FollowLeaderGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        private boolean canFollow() {
            return !FailgullEntity.this.getIsFlockLeader() && FailgullEntity.this.hasFlockLeader();
        }

        public boolean func_75250_a() {
            return this.canFollow() && FailgullEntity.this.func_70661_as().func_75500_f() && FailgullEntity.this.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return this.canFollow() && FailgullEntity.this.func_70661_as().func_226337_n_();
        }

        public void func_75249_e() {
            Entity flockLeader = FailgullEntity.this.getFlockLeader();
            PathNavigator navigator = FailgullEntity.this.func_70661_as();
            if (flockLeader != null && flockLeader.func_200600_R() == TropicraftEntities.FAILGULL.get()) {
                navigator.func_75484_a(navigator.func_179680_a(flockLeader.func_233580_cy_(), 1), 1.0);
                return;
            }
            BlockPos Vector3d2 = FailgullEntity.this.getRandomLocation();
            if (Vector3d2 != null) {
                navigator.func_75484_a(navigator.func_179680_a(Vector3d2, 1), 1.0);
            }
        }
    }
}

