/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive.basilisk;

import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.passive.basilisk.WaterWalking;
import net.tropicraft.core.common.item.TropicraftItems;

public final class BasiliskLizardEntity
extends AnimalEntity {
    private static final DataParameter<Boolean> RUNNING = EntityDataManager.func_187226_a(BasiliskLizardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final float WATER_WALK_SPEED_BOOST = 1.6f;
    private static final int WATER_WALK_TIME = 10;
    private static final int RUNNING_ANIMATION_LENGTH = 10;
    private int movingTimer;
    private boolean onWaterSurface;
    private int runningAnimation;
    private int prevRunningAnimation;

    public BasiliskLizardEntity(EntityType<? extends BasiliskLizardEntity> type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 0.0f);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    protected PathNavigator func_175447_b(World world) {
        return new WaterWalking.Navigator((MobEntity)this, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RUNNING, (Object)false);
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public BasiliskLizardEntity createChild(ServerWorld world, AgeableEntity mate) {
        return null;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        if (this.func_200600_R() == TropicraftEntities.BROWN_BASILISK_LIZARD.get()) {
            return new ItemStack((IItemProvider)TropicraftItems.BROWN_BASILISK_LIZARD_SPAWN_EGG.get());
        }
        return new ItemStack((IItemProvider)TropicraftItems.GREEN_BASILISK_LIZARD_SPAWN_EGG.get());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.func_201670_d()) {
            this.tickMovementTimer();
            this.tickSwimming();
            this.field_70180_af.func_187227_b(RUNNING, (Object)this.onWaterSurface);
        } else {
            this.tickRunningAnimation();
        }
    }

    private void tickRunningAnimation() {
        this.prevRunningAnimation = this.runningAnimation;
        if (((Boolean)this.field_70180_af.func_187225_a(RUNNING)).booleanValue()) {
            if (this.runningAnimation < 10) {
                ++this.runningAnimation;
            }
        } else if (this.runningAnimation > 0) {
            --this.runningAnimation;
        }
    }

    private void tickMovementTimer() {
        if (this.field_191988_bg != 0.0f) {
            this.movingTimer = 10;
        } else if (this.movingTimer > 0) {
            --this.movingTimer;
        }
    }

    private void tickSwimming() {
        boolean shouldWaterWalk;
        if (!this.onWaterSurface && this.func_70090_H() && this.func_233571_b_((ITag)FluidTags.field_206959_a) > this.func_233579_cu_() && ((shouldWaterWalk = this.shouldWaterWalk()) || this.field_70146_Z.nextFloat() < 0.8f)) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5).func_72441_c(0.0, 0.1, 0.0));
        }
    }

    protected Vector3d func_225514_a_(Vector3d offset, MoverType mover) {
        if (this.shouldWaterWalk()) {
            Vector3d result = WaterWalking.collide((IBlockReader)this.field_70170_p, this.func_174813_aQ(), offset);
            this.onWaterSurface = offset.field_72448_b < 0.0 && result.field_72448_b != offset.field_72448_b;
            return result;
        }
        this.onWaterSurface = false;
        return offset;
    }

    protected void func_184231_a(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.field_70122_E |= this.onWaterSurface;
        super.func_184231_a(y, this.field_70122_E, state, pos);
    }

    public float func_70689_ay() {
        float speed = super.func_70689_ay();
        return this.onWaterSurface ? speed * 1.6f : speed;
    }

    public boolean func_230285_a_(Fluid fluid) {
        return WaterWalking.canWalkOn(fluid);
    }

    private boolean shouldWaterWalk() {
        return this.movingTimer > 0;
    }

    public float getRunningAnimation(float partialTicks) {
        float animation = MathHelper.func_219799_g((float)partialTicks, (float)this.prevRunningAnimation, (float)this.runningAnimation);
        return animation / 10.0f;
    }
}

