/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.placeable;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class ChairEntity
extends FurnitureEntity {
    private static final DataParameter<Byte> COMESAILAWAY = EntityDataManager.func_187226_a(ChairEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public boolean isChairEmpty = true;
    private double speedMultiplier = 0.1;

    public ChairEntity(EntityType<ChairEntity> type, World world) {
        super(type, world, TropicraftItems.CHAIRS);
    }

    @Override
    public void func_70071_h_() {
        int j;
        double d4;
        double d2;
        double d10;
        super.func_70071_h_();
        int b0 = 5;
        double d0 = 0.0;
        if (this.getComeSailAway()) {
            for (int i = 0; i < b0; ++i) {
                double d1 = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)(i + 0) / (double)b0 - 0.125;
                double d3 = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)(i + 1) / (double)b0 - 0.125;
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.func_174813_aQ().field_72340_a, d1, this.func_174813_aQ().field_72339_c, this.func_174813_aQ().field_72336_d, d3, this.func_174813_aQ().field_72334_f);
                if (!this.field_70170_p.func_72953_d(axisalignedbb)) continue;
                d0 += 1.0 / (double)b0;
            }
        }
        if ((d10 = Math.sqrt(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c)) > 0.26249999999999996) {
            d2 = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            d4 = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            if (this.getComeSailAway()) {
                j = 0;
                while ((double)j < 1.0 + d10 * 60.0) {
                    double particleZ;
                    double particleX;
                    double d5 = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                    double d6 = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
                    if (this.field_70146_Z.nextBoolean()) {
                        particleX = this.func_226277_ct_() - d2 * d5 * 0.8 + d4 * d6;
                        particleZ = this.func_226281_cx_() - d4 * d5 * 0.8 - d2 * d6;
                    } else {
                        particleX = this.func_226277_ct_() + d2 + d4 * d5 * 0.7;
                        particleZ = this.func_226281_cx_() + d4 - d2 * d5 * 0.7;
                    }
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, particleX, this.func_226278_cu_() - 0.125, particleZ, this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
                    ++j;
                }
            }
        }
        if (!this.field_70170_p.field_72995_K || this.getComeSailAway()) {
            double d7;
            double d12;
            if (d0 < 1.0) {
                d2 = d0 * 2.0 - 1.0;
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)0.04f * d2, 0.0));
            } else {
                if (this.func_213322_ci().field_72448_b < 0.0) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.5, 1.0));
                }
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)0.007f, 0.0));
            }
            if (this.getComeSailAway() && this.func_184179_bs() != null && this.func_184179_bs() instanceof LivingEntity) {
                LivingEntity entitylivingbase = (LivingEntity)this.func_184179_bs();
                float f = this.func_184179_bs().field_70177_z + -entitylivingbase.field_70702_br * 90.0f;
                double moveX = -Math.sin(f * (float)Math.PI / 180.0f) * this.speedMultiplier * (double)entitylivingbase.field_191988_bg * (double)0.05f;
                double moveZ = Math.cos(f * (float)Math.PI / 180.0f) * this.speedMultiplier * (double)entitylivingbase.field_191988_bg * (double)0.05f;
                this.func_213317_d(this.func_213322_ci().func_72441_c(moveX, 0.0, moveZ));
            }
            if ((d2 = Math.sqrt(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c)) > 0.45) {
                d4 = 0.45 / d2;
                this.func_213317_d(this.func_213322_ci().func_216372_d(d4, 1.0, d4));
                d2 = 0.45;
            }
            if (d2 > d10 && this.speedMultiplier < 0.45) {
                this.speedMultiplier += (0.45 - this.speedMultiplier) / 45.0;
                if (this.speedMultiplier > 0.45) {
                    this.speedMultiplier = 0.45;
                }
            } else {
                this.speedMultiplier -= (this.speedMultiplier - 0.1) / 45.0;
                if (this.speedMultiplier < 0.1) {
                    this.speedMultiplier = 0.1;
                }
            }
            if (this.getComeSailAway()) {
                for (int l = 0; l < 4; ++l) {
                    int i1 = MathHelper.func_76128_c((double)(this.func_226277_ct_() + ((double)(l % 2) - 0.5) * 0.8));
                    j = MathHelper.func_76128_c((double)(this.func_226281_cx_() + ((double)(l / 2) - 0.5) * 0.8));
                    for (int j1 = 0; j1 < 2; ++j1) {
                        int k = MathHelper.func_76128_c((double)this.func_226278_cu_()) + j1;
                        BlockPos pos = new BlockPos(i1, k, j);
                        Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
                        if (block == Blocks.field_150433_aE) {
                            this.field_70170_p.func_175655_b(pos, true);
                            this.field_70123_F = false;
                            continue;
                        }
                        if (block != Blocks.field_196651_dG) continue;
                        this.field_70170_p.func_175655_b(pos, true);
                        this.field_70123_F = false;
                    }
                }
            }
            if (this.getComeSailAway() && this.field_70122_E) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, 0.5, 0.5));
            } else if (this.field_70122_E) {
                this.func_213317_d(Vector3d.field_186680_a);
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (this.getComeSailAway()) {
                this.func_213317_d(this.func_213322_ci().func_216372_d((double)0.99f, (double)0.95f, (double)0.99f));
            }
            this.field_70125_A = 0.0f;
            d4 = this.field_70177_z;
            double d11 = this.field_70169_q - this.func_226277_ct_();
            if (d11 * d11 + (d12 = this.field_70166_s - this.func_226281_cx_()) * d12 > 0.001) {
                d4 = (float)(Math.atan2(d12, d11) * 180.0 / Math.PI);
            }
            if ((d7 = MathHelper.func_76138_g((double)(d4 - (double)this.field_70177_z))) > 20.0) {
                d7 = 20.0;
            }
            if (d7 < -20.0) {
                d7 = -20.0;
            }
            this.field_70177_z = (float)((double)this.field_70177_z + d7);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, 0.0, (double)0.2f));
                if (list != null && !list.isEmpty()) {
                    for (int k1 = 0; k1 < list.size(); ++k1) {
                        Entity entity = (Entity)list.get(k1);
                        if (entity == this.func_184179_bs() || !entity.func_70104_M() || !(entity instanceof ChairEntity)) continue;
                        entity.func_70108_f((Entity)this);
                    }
                }
                if (this.func_184179_bs() != null && !this.func_184179_bs().func_70089_S()) {
                    this.func_184226_ay();
                }
            }
        } else {
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
    }

    @Override
    protected boolean preventMotion() {
        return !this.getComeSailAway();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(COMESAILAWAY, (Object)new Byte(0));
    }

    @Override
    protected void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setComeSailAway(nbt.func_74767_n("COME_SAIL_AWAY"));
    }

    @Override
    protected void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("COME_SAIL_AWAY", this.getComeSailAway());
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K && !player.func_225608_bj_()) {
            player.func_184220_m((Entity)this);
            return ActionResultType.SUCCESS;
        }
        return !player.func_184223_x((Entity)this) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    @Override
    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    @Override
    public double func_70042_X() {
        return 0.11;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            Vector3d xzOffset = new Vector3d(0.0, 0.0, -0.125).func_178785_b((float)Math.toRadians(-this.field_70177_z));
            passenger.func_70107_b(this.func_226277_ct_() + xzOffset.field_72450_a, this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W(), this.func_226281_cx_() + xzOffset.field_72449_c);
        }
    }

    public void setComeSailAway(boolean sail) {
        this.field_70180_af.func_187227_b(COMESAILAWAY, (Object)(sail ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0)));
    }

    public boolean getComeSailAway() {
        return (Byte)this.field_70180_af.func_187225_a(COMESAILAWAY) == 1;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.CHAIRS.get(DyeColor.func_196056_a((int)this.getColor().func_196059_a())).get());
    }
}

