/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.placeable;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class FurnitureEntity
extends Entity {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(FurnitureEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(FurnitureEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.func_187226_a(FurnitureEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(FurnitureEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int DAMAGE_THRESHOLD = 40;
    private final Function<DyeColor, Item> itemLookup;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYaw = Double.NaN;
    protected double lerpPitch;

    protected FurnitureEntity(EntityType<?> entityTypeIn, World worldIn, Map<DyeColor, ? extends RegistryObject<? extends Item>> items) {
        this(entityTypeIn, worldIn, (DyeColor c) -> (Item)((RegistryObject)items.get(c)).get());
    }

    protected FurnitureEntity(EntityType<?> entityTypeIn, World worldIn, Function<DyeColor, Item> itemLookup) {
        super(entityTypeIn, worldIn);
        this.itemLookup = itemLookup;
        this.field_70158_ak = true;
        this.field_70156_m = true;
        this.field_70144_Y = 0.95f;
    }

    public void setRotation(float yaw) {
        this.field_70177_z = MathHelper.func_76142_g((float)yaw);
        this.lerpYaw = this.field_70177_z;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(COLOR, (Object)0);
        this.func_184212_Q().func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(FORWARD_DIRECTION, (Object)1);
        this.func_184212_Q().func_187214_a(TIME_SINCE_HIT, (Object)0);
    }

    public void func_70071_h_() {
        float damage;
        int timeSinceHit = this.getTimeSinceHit();
        if (timeSinceHit > 0) {
            this.setTimeSinceHit(timeSinceHit - 1);
        }
        if ((damage = this.getDamage()) > 0.0f) {
            this.setDamage(damage - 1.0f);
        }
        Vector3d currentPos = this.func_213303_ch();
        this.field_70169_q = currentPos.field_72450_a;
        this.field_70167_r = currentPos.field_72448_b;
        this.field_70166_s = currentPos.field_72449_c;
        super.func_70071_h_();
        this.tickLerp();
        if (this.preventMotion()) {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntityPredicates.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.func_184196_w((Entity)this)) continue;
                this.func_70108_f(entity);
            }
        }
    }

    protected boolean preventMotion() {
        return true;
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (teleport) {
            super.func_180426_a(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        } else {
            this.lerpX = x;
            this.lerpY = y;
            this.lerpZ = z;
            if (yaw != this.field_70177_z || Double.isNaN(this.lerpYaw)) {
                this.lerpYaw = MathHelper.func_76138_g((double)yaw);
            }
            this.lerpSteps = 10;
            this.field_70125_A = pitch;
        }
    }

    private void tickLerp() {
        if (this.lerpSteps > 0) {
            double d0 = this.func_226277_ct_() + (this.lerpX - this.func_226277_ct_()) / (double)this.lerpSteps;
            double d1 = this.func_226278_cu_() + (this.lerpY - this.func_226278_cu_()) / (double)this.lerpSteps;
            double d2 = this.func_226281_cx_() + (this.lerpZ - this.func_226281_cx_()) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            boolean flag;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamage(this.getDamage() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = damageSource.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)damageSource.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamage() > 40.0f) {
                Entity rider = this.func_184179_bs();
                if (rider != null) {
                    rider.func_184220_m((Entity)this);
                }
                if (!flag) {
                    this.func_70099_a(this.getItemStack(), 0.0f);
                }
                this.func_70106_y();
            }
        }
        return true;
    }

    private ItemStack getItemStack() {
        return new ItemStack((IItemProvider)this.itemLookup.apply(this.getColor()));
    }

    public double func_70042_X() {
        return 0.0;
    }

    public void func_70057_ab() {
        this.setForwardDirection(-1 * this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamage(this.getDamage() * 10.0f);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_70037_a(CompoundNBT nbt) {
        this.setColor(DyeColor.func_196056_a((int)nbt.func_74762_e("Color")));
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_74768_a("Color", this.getColor().ordinal());
    }

    public void setColor(DyeColor color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color.ordinal());
    }

    public DyeColor getColor() {
        return DyeColor.func_196056_a((int)((Integer)this.field_70180_af.func_187225_a(COLOR)));
    }

    public void setForwardDirection(int dir) {
        this.field_70180_af.func_187227_b(FORWARD_DIRECTION, (Object)dir);
    }

    public int getForwardDirection() {
        return (Integer)this.field_70180_af.func_187225_a(FORWARD_DIRECTION);
    }

    public void setDamage(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damageTaken));
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }
}

