/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.tropicraft.core.common.item.TropicraftItems;

public class EagleRayEntity
extends AbstractFishEntity {
    public static final int WING_JOINTS = 10;
    public static final int WING_CYCLE_TICKS = 60;
    public static final float PHASES = 0.33f;
    private float[] wingAmplitudes = new float[10];
    private float[] prevWingAmplitudes = new float[10];
    private int animationTicks;

    public EagleRayEntity(EntityType<? extends EagleRayEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return AbstractFishEntity.func_234176_m_().func_233815_a_(Attributes.field_233818_a_, 10.0);
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        return ActionResultType.PASS;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.animationTicks = this.animationTicks < 60 ? ++this.animationTicks : 0;
            this.updateWingAmplitudes();
        }
    }

    private void updateWingAmplitudes() {
        float[] temp = this.prevWingAmplitudes;
        this.prevWingAmplitudes = this.wingAmplitudes;
        this.wingAmplitudes = temp;
        for (int i = 1; i < 10; ++i) {
            this.wingAmplitudes[i] = this.amplitudeFunc(i);
        }
    }

    private float decayFunc(float n) {
        return n / 9.0f;
    }

    private float amplitudeFunc(float n) {
        double angle = Math.PI * 2 * (double)(-n) / 9.0;
        return this.decayFunc(n) * MathHelper.func_76126_a((float)((float)((double)(this.getAnimationProgress() * 2.0f) * Math.PI + (double)0.33f * angle)));
    }

    private float getAnimationProgress() {
        return (float)this.animationTicks / 60.0f;
    }

    public float[] getWingAmplitudes() {
        return this.wingAmplitudes;
    }

    public float[] getPrevWingAmplitudes() {
        return this.prevWingAmplitudes;
    }

    protected ItemStack func_203707_dx() {
        return ItemStack.field_190927_a;
    }

    protected SoundEvent func_203701_dz() {
        return SoundEvents.field_203822_gO;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.EAGLE_RAY_SPAWN_EGG.get());
    }
}

