/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tropicraft.core.common.entity.ai.fishies.AvoidWallsGoal;
import net.tropicraft.core.common.entity.ai.fishies.RandomSwimGoal;
import net.tropicraft.core.common.entity.ai.fishies.SwimToAvoidEntityGoal;
import net.tropicraft.core.common.entity.ai.fishies.TargetPreyGoal;
import net.tropicraft.core.common.entity.underdasea.TropicraftFishEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class SharkEntity
extends TropicraftFishEntity {
    private static final DataParameter<Boolean> IS_BOSS = EntityDataManager.func_187226_a(SharkEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);
    private ArrayList<ServerPlayerEntity> bossTargets = new ArrayList();
    private boolean hasSetBoss = false;

    public SharkEntity(EntityType<? extends WaterMobEntity> type, World world) {
        super(type, world);
        this.field_70728_aV = 20;
        this.setApproachesPlayers(true);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidWallsGoal(EnumSet.of(Goal.Flag.MOVE), this));
        if (this.fleeFromPlayers) {
            this.field_70714_bg.func_75776_a(0, (Goal)new SwimToAvoidEntityGoal(EnumSet.of(Goal.Flag.MOVE), this, 5.0, new Class[]{PlayerEntity.class}));
        }
        this.field_70714_bg.func_75776_a(2, (Goal)new TargetPreyGoal(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK), this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomSwimGoal(EnumSet.of(Goal.Flag.MOVE), this));
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_BOSS, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return WaterMobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    public void setBoss() {
        this.func_184212_Q().func_187227_b(IS_BOSS, (Object)true);
    }

    public boolean isBoss() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_BOSS);
    }

    private void setBossTraits() {
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(8.0);
        this.func_200203_b((ITextComponent)new StringTextComponent("Elder Hammerhead"));
        this.func_174805_g(true);
        this.setSwimSpeeds(1.1f, 2.2f, 1.5f, 3.0f, 5.0f);
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
        if (!this.field_70170_p.field_72995_K) {
            this.bossInfo.func_186739_a((ITextComponent)new StringTextComponent("Elder Hammerhead"));
        }
        this.hasSetBoss = true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isBoss()) {
            if (!this.hasSetBoss) {
                this.setBossTraits();
            }
            if (!this.field_70170_p.field_72995_K) {
                PlayerEntity nearest = this.field_70170_p.func_217362_a((Entity)this, 64.0);
                if (nearest != null) {
                    if (this.func_70685_l((Entity)nearest) && nearest.func_70090_H() && !nearest.func_184812_l_() && nearest.func_70089_S()) {
                        this.aggressTarget = nearest;
                        this.setTargetHeading(this.aggressTarget.func_226277_ct_(), this.aggressTarget.func_226278_cu_() + 1.0, this.aggressTarget.func_226281_cx_(), true);
                        if (nearest instanceof ServerPlayerEntity && !this.bossInfo.func_186757_c().contains(nearest)) {
                            this.bossTargets.add((ServerPlayerEntity)nearest);
                            this.bossInfo.func_186760_a((ServerPlayerEntity)nearest);
                        }
                    } else {
                        this.clearBossTargets();
                    }
                } else {
                    this.clearBossTargets();
                }
                if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 80 == 0 && this.aggressTarget == null) {
                    this.func_70691_i(1.0f);
                    this.func_70656_aK();
                }
                this.bossInfo.func_186735_a(this.rangeMap(this.func_110143_aJ(), 0.0f, this.func_110138_aP(), 0.0f, 1.0f));
            }
        }
    }

    private void clearBossTargets() {
        if (this.bossTargets.size() > 0) {
            for (ServerPlayerEntity p : this.bossTargets) {
                this.bossInfo.func_186761_b(p);
            }
            this.bossTargets.clear();
        }
    }

    public void func_213281_b(CompoundNBT n) {
        n.func_74757_a("isBoss", this.isBoss());
        super.func_213281_b(n);
    }

    public void func_70037_a(CompoundNBT n) {
        if (n.func_74767_n("isBoss")) {
            this.setBoss();
        }
        super.func_70037_a(n);
    }

    public boolean func_213397_c(double p) {
        return !this.isBoss() && super.func_213397_c(p);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.HAMMERHEAD_SPAWN_EGG.get());
    }
}

