/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.egg.EggEntity;
import net.tropicraft.core.common.entity.egg.StarfishEggEntity;
import net.tropicraft.core.common.entity.underdasea.EchinodermEntity;
import net.tropicraft.core.common.entity.underdasea.StarfishType;
import net.tropicraft.core.common.item.TropicraftItems;

public class StarfishEntity
extends EchinodermEntity
implements IEntityAdditionalSpawnData {
    public static final float BABY_WIDTH = 0.25f;
    public static final float ADULT_WIDTH = 1.0f;
    public static final float BABY_HEIGHT = 0.1f;
    public static final float ADULT_HEIGHT = 0.2f;
    public static final float BABY_YOFFSET = 0.03125f;
    public static final float ADULT_YOFFSET = 0.03125f;
    private static final DataParameter<Byte> DATA_STARFISH_TYPE = EntityDataManager.func_187226_a(StarfishEntity.class, (IDataSerializer)DataSerializers.field_187191_a);

    public StarfishEntity(EntityType<? extends StarfishEntity> type, World world) {
        super(type, world);
        this.field_70728_aV = 5;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData entityData, @Nullable CompoundNBT nbt) {
        this.setStarfishType(StarfishType.values()[this.field_70146_Z.nextInt(StarfishType.values().length)]);
        return super.func_213386_a(world, difficultyInstance, spawnReason, entityData, nbt);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_STARFISH_TYPE, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return WaterMobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0);
    }

    public StarfishType getStarfishType() {
        return StarfishType.values()[(Byte)this.field_70180_af.func_187225_a(DATA_STARFISH_TYPE)];
    }

    public void setStarfishType(StarfishType starfishType) {
        this.field_70180_af.func_187227_b(DATA_STARFISH_TYPE, (Object)((byte)starfishType.ordinal()));
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74774_a("StarfishType", (byte)this.getStarfishType().ordinal());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("StarfishType")) {
            this.setStarfishType(StarfishType.values()[nbt.func_74771_c("StarfishType")]);
        } else {
            this.setStarfishType(StarfishType.RED);
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeByte(this.getStarfishType().ordinal());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.setStarfishType(StarfishType.values()[additionalData.readByte()]);
    }

    @Override
    public EggEntity createEgg() {
        StarfishEggEntity entity = new StarfishEggEntity((EntityType<? extends StarfishEggEntity>)((EntityType)TropicraftEntities.STARFISH_EGG.get()), this.field_70170_p);
        entity.setStarfishType(this.getStarfishType());
        return entity;
    }

    @Override
    public float getBabyWidth() {
        return 0.25f;
    }

    @Override
    public float getAdultWidth() {
        return 1.0f;
    }

    @Override
    public float getBabyHeight() {
        return 0.1f;
    }

    @Override
    public float getAdultHeight() {
        return 0.2f;
    }

    @Override
    public float getBabyYOffset() {
        return 0.03125f;
    }

    @Override
    public float getAdultYOffset() {
        return 0.03125f;
    }

    @Override
    public boolean isPotentialMate(EchinodermEntity other) {
        return super.isPotentialMate(other) && ((StarfishEntity)other).getStarfishType() == this.getStarfishType();
    }

    public void func_70645_a(DamageSource d) {
        super.func_70645_a(d);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70099_a(new ItemStack((IItemProvider)TropicraftItems.STARFISH.get()), 0.0f);
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.STARFISH.get());
    }
}

