/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class TropicraftFishEntity
extends WaterMobEntity {
    public float swimPitch = 0.0f;
    public float swimYaw = 0.0f;
    public Vector2f targetVectorHeading;
    public Vector3d targetVector;
    public int outOfWaterTime = 0;
    public float outOfWaterAngle = 0.0f;
    public float fallVelocity = 0.0f;
    public float fallGravity = 0.0625f;
    public float prevSwimPitch = 0.0f;
    public float prevSwimYaw = 0.0f;
    private float swimSpeedDefault = 1.0f;
    protected float swimSpeedCurrent = 0.0f;
    private float swimSpeedPanic = 2.0f;
    private float swimAccelRate = 0.02f;
    private float swimDecelRate = 0.02f;
    private float swimSpeedTurn = 5.0f;
    public boolean isMovingAwayFromWall = false;
    public boolean isPanicking = false;
    public boolean fleeFromPlayers = false;
    public boolean approachPlayers = false;
    public double fleeDistance = 2.0;
    public boolean isAggressing = false;
    public boolean canAggress = false;
    public int eatenFishAmount = 0;
    public int maximumEatAmount = 5;
    private float swimSpeedChasing = 2.0f;
    private float swimSpeedCharging = 2.5f;
    public Entity aggressTarget = null;
    private boolean fishable = false;

    protected TropicraftFishEntity(EntityType<? extends WaterMobEntity> type, World world) {
        super(type, world);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.field_70125_A = -this.swimPitch;
            this.field_70177_z = -this.swimYaw;
            this.field_70759_as = -this.swimYaw;
            this.field_70758_at = -this.prevSwimYaw;
            this.field_70761_aq = 0.0f;
            this.field_70127_C = -this.prevSwimPitch;
            this.field_70126_B = -this.prevSwimYaw;
            double x = this.func_226277_ct_() - this.field_70169_q;
            double y = this.func_226278_cu_() - this.field_70167_r;
            double z = this.func_226281_cx_() - this.field_70166_s;
            this.prevSwimYaw = this.swimYaw;
            this.prevSwimPitch = this.swimPitch;
            float yaw = this.func_226277_ct_() == this.field_70169_q && this.func_226281_cx_() == this.field_70166_s ? this.swimYaw : (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
            float pitch = this.func_226278_cu_() == this.field_70167_r ? this.swimPitch : (float)(-(Math.atan2(y, MathHelper.func_76133_a((double)(x * x + z * z))) * 180.0 / Math.PI));
            this.swimYaw = this.lerp(this.swimYaw, (int)(-yaw), this.swimSpeedTurn * 4.0f);
            this.swimPitch = this.lerp(this.swimPitch, (int)(-pitch), this.swimSpeedTurn * 4.0f);
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.98, 0.98, 0.98));
            if (this.func_175446_cd() && this.func_70090_H()) {
                this.fallVelocity = 0.0f;
                this.swimSpeedCurrent = 0.0f;
                this.func_213317_d(Vector3d.field_186680_a);
            }
        }
        if (this.func_70090_H()) {
            if (this.isMovingAwayFromWall) {
                this.swimSpeedTurn *= 1.8f;
            }
            if (this.targetVectorHeading != null) {
                this.swimYaw = this.lerp(this.swimYaw, -this.targetVectorHeading.field_189982_i, this.swimSpeedTurn);
                this.swimPitch = this.lerp(this.swimPitch, -this.targetVectorHeading.field_189983_j, this.swimSpeedTurn);
            }
        }
        if (!this.func_70090_H()) {
            this.setTargetHeading(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_(), false);
        }
        float currentSpeed = this.swimSpeedCurrent;
        float desiredSpeed = this.swimSpeedDefault;
        if (this.aggressTarget != null) {
            desiredSpeed = this.func_70068_e(this.aggressTarget) < 10.0 ? this.swimSpeedCharging : this.swimSpeedChasing;
        }
        if (this.isPanicking) {
            desiredSpeed = this.swimSpeedPanic;
        }
        if (this.field_70173_aa % 50 < 30) {
            desiredSpeed *= 0.8f;
        }
        if (this.isMovingAwayFromWall) {
            desiredSpeed *= 0.6f;
            currentSpeed *= 0.8f;
        }
        if (this.swimSpeedCurrent < desiredSpeed) {
            this.swimSpeedCurrent += this.swimAccelRate;
        }
        if (this.swimSpeedCurrent > desiredSpeed) {
            this.swimSpeedCurrent -= this.swimDecelRate;
        }
        currentSpeed *= 0.1f;
        if (this.func_70090_H()) {
            this.func_213293_j((double)currentSpeed * Math.sin((double)this.swimYaw * (Math.PI / 180)), (double)currentSpeed * Math.sin((double)this.swimPitch * (Math.PI / 180)), (double)currentSpeed * Math.cos((double)this.swimYaw * (Math.PI / 180)));
            this.fallVelocity = 0.0f;
        }
        if (this.func_175446_cd() && this.func_70090_H()) {
            this.func_213293_j(0.0, 0.0, 0.0);
            this.fallVelocity = 0.0f;
            this.swimSpeedCurrent = 0.0f;
        }
        if (this.swimPitch > 45.0f) {
            this.swimPitch = 45.0f;
        }
    }

    public float rangeMap(float input, float inpMin, float inpMax, float outMin, float outMax) {
        if ((double)Math.abs(inpMax - inpMin) < 1.0E-12) {
            return 0.0f;
        }
        double ratio = (outMax - outMin) / (inpMax - inpMin);
        return (float)(ratio * (double)(input - inpMin) + (double)outMin);
    }

    public void setSwimSpeeds(float regular, float panic, float turnSpeed) {
        this.swimSpeedDefault = regular;
        this.swimSpeedPanic = panic;
        this.swimSpeedTurn = turnSpeed;
    }

    public void setSwimSpeeds(float r, float p, float t, float chasing, float charging) {
        this.setSwimSpeeds(r, p, t);
        this.swimSpeedChasing = chasing;
        this.swimSpeedCharging = charging;
    }

    public void setApproachesPlayers(boolean b) {
        this.approachPlayers = b;
    }

    public float lerp(float x1, float x2, float t) {
        return x1 + t * 0.03f * MathHelper.func_76142_g((float)(x2 - x1));
    }

    public boolean setTargetHeading(double posX, double posY, double posZ, boolean waterChecks) {
        BlockPos bp;
        BlockState stateAtPos;
        if (this.func_175446_cd()) {
            return false;
        }
        if (waterChecks && (!(stateAtPos = this.field_70170_p.func_180495_p(bp = new BlockPos((int)posX, (int)posY, (int)posZ))).func_185904_a().func_76224_d() || stateAtPos.func_185904_a().func_76220_a())) {
            return false;
        }
        double x = (int)(posX - this.func_226277_ct_());
        double y = (int)(posY - this.func_226278_cu_());
        double z = (int)(posZ - this.func_226281_cx_());
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y, MathHelper.func_76133_a((double)(x * x + z * z))) * 180.0 / Math.PI));
        this.targetVector = new Vector3d((double)((int)posX), (double)((int)posY), (double)((int)posZ));
        this.targetVectorHeading = new Vector2f(yaw, pitch);
        return true;
    }

    public Vector3d getHeading() {
        return new Vector3d(Math.sin((double)this.swimYaw * (Math.PI / 180)), Math.sin((double)this.swimPitch * (Math.PI / 180)), Math.cos((double)this.swimYaw * (Math.PI / 180))).func_72432_b();
    }

    public void setRandomTargetHeadingForce(int maxTimes) {
        for (int i = 0; i < maxTimes && !this.setRandomTargetHeading(); ++i) {
        }
    }

    public boolean setRandomTargetHeading() {
        PlayerEntity closest;
        boolean result = false;
        int dist = 16;
        Vector3d randBlock = new Vector3d(this.func_226277_ct_() + (double)this.randFlip(dist), this.func_226278_cu_() + (double)this.randFlip(dist / 2), this.func_226281_cx_() + (double)this.randFlip(dist));
        result = this.setTargetHeading(randBlock.field_72450_a, randBlock.field_72448_b, randBlock.field_72449_c, true);
        if (this.approachPlayers && this.field_70146_Z.nextInt(50) == 0 && (closest = this.field_70170_p.func_217362_a((Entity)this, 32.0)) != null && closest.func_70090_H()) {
            result = this.setTargetHeading(closest.func_226277_ct_(), closest.func_226278_cu_(), closest.func_226281_cx_(), true);
        }
        return result;
    }

    public void fleeEntity(Entity ent) {
        double x = ent.func_226277_ct_() - this.func_226277_ct_();
        double y = ent.func_226278_cu_() - this.func_226278_cu_();
        double z = ent.func_226281_cx_() - this.func_226281_cx_();
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y, MathHelper.func_76133_a((double)(x * x + z * z))) * 180.0 / Math.PI));
        if (this.targetVector == null) {
            this.targetVector = new Vector3d(ent.func_226277_ct_(), ent.func_226278_cu_() - 5.0 + (double)this.field_70146_Z.nextInt(10), ent.func_226281_cx_());
        }
        this.targetVectorHeading = new Vector2f(yaw + 180.0f, -1.0f * pitch / 2.0f);
    }

    public int randFlip(int i) {
        return this.field_70146_Z.nextBoolean() ? this.field_70146_Z.nextInt(i) : -this.field_70146_Z.nextInt(i);
    }
}

