/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.item.TropicraftItems;

public class ArmorMaterials {
    private static final Ingredient NO_INGREDIENT = new Ingredient(Stream.empty()){

        public boolean test(@Nullable ItemStack stack) {
            return false;
        }
    };
    public static final IArmorMaterial ASHEN_MASK = new AshenMask();
    public static final IArmorMaterial NIGEL_STACHE = new NigelStache();
    public static final IArmorMaterial SCALE_ARMOR = ArmorMaterials.createArmorMaterial(18, new int[]{2, 5, 6, 2}, 9, SoundEvents.field_187713_n, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TropicraftItems.SCALE.get()}), "scale", 0.5f, 0.0f);
    public static final IArmorMaterial FIRE_ARMOR = ArmorMaterials.createArmorMaterial(12, new int[]{2, 4, 5, 2}, 9, SoundEvents.field_187725_r, NO_INGREDIENT, "fire", 0.1f, 0.0f);
    public static final IArmorMaterial SCUBA = ArmorMaterials.createArmorMaterial(10, new int[]{0, 0, 0, 0}, 0, SoundEvents.field_187719_p, NO_INGREDIENT, "scuba_goggles", 0.0f, 0.0f);

    public static IArmorMaterial createArmorMaterial(final int durability, final int[] dmgReduction, final int enchantability, final SoundEvent soundEvent, final Ingredient repairMaterial, final String name, final float toughness, final float knockbackResistance) {
        return new IArmorMaterial(){

            public int func_200896_a(EquipmentSlotType equipmentSlotType) {
                return durability;
            }

            public int func_200902_b(EquipmentSlotType equipmentSlotType) {
                return dmgReduction[equipmentSlotType.func_188454_b()];
            }

            public int func_200900_a() {
                return enchantability;
            }

            public SoundEvent func_200899_b() {
                return soundEvent;
            }

            public Ingredient func_200898_c() {
                return repairMaterial;
            }

            public String func_200897_d() {
                return name;
            }

            public float func_200901_e() {
                return toughness;
            }

            public float func_230304_f_() {
                return knockbackResistance;
            }
        };
    }

    private static class NigelStache
    implements IArmorMaterial {
        private NigelStache() {
        }

        public int func_200896_a(EquipmentSlotType slotIn) {
            return 10;
        }

        public int func_200902_b(EquipmentSlotType slotIn) {
            return slotIn == EquipmentSlotType.HEAD ? 1 : 0;
        }

        public int func_200900_a() {
            return 15;
        }

        public SoundEvent func_200899_b() {
            return SoundEvents.field_187728_s;
        }

        public Ingredient func_200898_c() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TropicraftItems.NIGEL_STACHE.get()});
        }

        public String func_200897_d() {
            return "nigel";
        }

        public float func_200901_e() {
            return 0.0f;
        }

        public float func_230304_f_() {
            return 0.0f;
        }
    }

    private static class AshenMask
    implements IArmorMaterial {
        private AshenMask() {
        }

        public int func_200896_a(EquipmentSlotType slotIn) {
            return 10;
        }

        public int func_200902_b(EquipmentSlotType slotIn) {
            return slotIn == EquipmentSlotType.HEAD ? 1 : 0;
        }

        public int func_200900_a() {
            return 15;
        }

        public SoundEvent func_200899_b() {
            return SoundEvents.field_187728_s;
        }

        public Ingredient func_200898_c() {
            return Ingredient.func_199805_a(TropicraftTags.Items.ASHEN_MASKS);
        }

        public String func_200897_d() {
            return "mask";
        }

        public float func_200901_e() {
            return 0.0f;
        }

        public float func_230304_f_() {
            return 0.0f;
        }
    }
}

