/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.client.entity.model.PlayerHeadpieceRenderer;
import net.tropicraft.core.common.entity.placeable.WallItemEntity;
import net.tropicraft.core.common.item.AshenMasks;

public class AshenMaskItem
extends ArmorItem {
    private final AshenMasks maskType;

    public AshenMaskItem(IArmorMaterial armorMaterial, AshenMasks maskType, Item.Properties properties) {
        super(armorMaterial, EquipmentSlotType.HEAD, properties);
        this.maskType = maskType;
    }

    public AshenMasks getMaskType() {
        return this.maskType;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        BlockPos offsetPos = pos.func_177972_a(direction);
        PlayerEntity player = context.func_195999_j();
        ItemStack itemStack = context.func_195996_i();
        if (player != null && !this.canPlace(player, direction, itemStack, offsetPos)) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        WallItemEntity wallItem = new WallItemEntity(world, offsetPos, direction);
        wallItem.func_82334_a(itemStack);
        if (wallItem.func_70518_d()) {
            if (!world.field_72995_K) {
                wallItem.func_184523_o();
                world.func_217376_c((Entity)wallItem);
            }
            itemStack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    private boolean canPlace(PlayerEntity player, Direction direction, ItemStack heldStack, BlockPos pos) {
        return player.func_175151_a(pos, direction, heldStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public BipedModel getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, BipedModel model) {
        return armorSlot == EquipmentSlotType.HEAD ? new PlayerHeadpieceRenderer(this.maskType.ordinal(), this.maskType.getXOffset(), this.maskType.getYOffset()) : null;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return TropicraftRenderUtils.getTextureEntity("ashen/mask").toString();
    }
}

