/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Food;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.Rarity;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraftforge.fml.RegistryObject;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.placeable.BeachFloatEntity;
import net.tropicraft.core.common.entity.placeable.ChairEntity;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;
import net.tropicraft.core.common.entity.placeable.UmbrellaEntity;
import net.tropicraft.core.common.item.ArmorMaterials;
import net.tropicraft.core.common.item.AshenMaskItem;
import net.tropicraft.core.common.item.AshenMasks;
import net.tropicraft.core.common.item.CocktailItem;
import net.tropicraft.core.common.item.FireArmorItem;
import net.tropicraft.core.common.item.FurnitureItem;
import net.tropicraft.core.common.item.RecordMusic;
import net.tropicraft.core.common.item.ScaleArmorItem;
import net.tropicraft.core.common.item.ShellItem;
import net.tropicraft.core.common.item.TropicalMusicDiscItem;
import net.tropicraft.core.common.item.TropicraftFishBucketItem;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.item.TropicraftSpawnEgg;
import net.tropicraft.core.common.item.scuba.ScubaFlippersItem;
import net.tropicraft.core.common.item.scuba.ScubaGogglesItem;
import net.tropicraft.core.common.item.scuba.ScubaHarnessItem;
import net.tropicraft.core.common.item.scuba.ScubaType;

public class Builder {
    public static Supplier<Item> item() {
        return Builder.item(Builder.getDefaultProperties());
    }

    public static Supplier<Item> item(Item.Properties properties) {
        return Builder.item(Item::new, properties);
    }

    public static <T> Supplier<T> item(Function<Item.Properties, T> ctor) {
        return Builder.item(ctor, Builder.getDefaultProperties());
    }

    public static <T> Supplier<T> item(Function<Item.Properties, T> ctor, Item.Properties properties) {
        return Builder.item(ctor, () -> properties);
    }

    public static <T> Supplier<T> item(Function<Item.Properties, T> ctor, Supplier<Item.Properties> properties) {
        return () -> ctor.apply((Item.Properties)properties.get());
    }

    public static Supplier<BlockNamedItem> blockNamedItem(Supplier<? extends Block> block) {
        return Builder.item((Item.Properties p) -> new BlockNamedItem((Block)block.get(), p));
    }

    private static <T extends FurnitureEntity> Supplier<FurnitureItem<T>> furniture(Supplier<EntityType<T>> type, DyeColor color) {
        return Builder.item((Item.Properties p) -> new FurnitureItem((Item.Properties)p, type, color));
    }

    public static Supplier<FurnitureItem<UmbrellaEntity>> umbrella(DyeColor color) {
        return Builder.furniture(TropicraftEntities.UMBRELLA, color);
    }

    public static Supplier<FurnitureItem<ChairEntity>> chair(DyeColor color) {
        return Builder.furniture(TropicraftEntities.CHAIR, color);
    }

    public static Supplier<FurnitureItem<BeachFloatEntity>> beachFloat(DyeColor color) {
        return Builder.furniture(TropicraftEntities.BEACH_FLOAT, color);
    }

    public static <T extends AbstractFishEntity> Supplier<Item> fishBucket(Supplier<EntityType<T>> type) {
        return Builder.item((Item.Properties p) -> new TropicraftFishBucketItem(type, (Fluid)Fluids.field_204546_a, Builder.getDefaultProperties().func_200917_a(1)));
    }

    public static Supplier<Item> shell() {
        return Builder.item(ShellItem::new);
    }

    public static Supplier<Item> food(Food food) {
        return Builder.item(Builder.getDefaultProperties().func_221540_a(food));
    }

    public static Supplier<CocktailItem> cocktail(Drink drink) {
        return Builder.item((Item.Properties p) -> {
            CocktailItem ret = new CocktailItem(drink, (Item.Properties)p);
            MixerRecipes.setDrinkItem(drink, ret);
            return ret;
        }, () -> Builder.getDefaultProperties().func_200918_c(0).func_200917_a(1).func_200919_a((Item)TropicraftItems.BAMBOO_MUG.get()));
    }

    public static Supplier<AshenMaskItem> mask(AshenMasks mask) {
        return Builder.item((Item.Properties p) -> new AshenMaskItem(ArmorMaterials.ASHEN_MASK, mask, (Item.Properties)p));
    }

    public static Supplier<TropicalMusicDiscItem> musicDisc(RecordMusic type) {
        return Builder.item((Item.Properties p) -> new TropicalMusicDiscItem(type, (Item.Properties)p){}, () -> Builder.getDefaultProperties().func_208103_a(Rarity.RARE));
    }

    public static <T extends Entity> Supplier<Item> spawnEgg(RegistryObject<EntityType<T>> type) {
        return Builder.item((Item.Properties p) -> new TropicraftSpawnEgg(type, (Item.Properties)p), Builder::getDefaultProperties);
    }

    public static Supplier<Item> hoe(IItemTier tier) {
        return Builder.item((Item.Properties p) -> new HoeItem(tier, 0, -2.0f, Builder.getDefaultProperties()));
    }

    public static Supplier<Item> shovel(IItemTier tier) {
        return Builder.item((Item.Properties p) -> new ShovelItem(tier, 2.0f, -3.0f, Builder.getDefaultProperties()));
    }

    public static Supplier<Item> pickaxe(IItemTier tier) {
        return Builder.item((Item.Properties p) -> new PickaxeItem(tier, 2, -2.0f, Builder.getDefaultProperties()));
    }

    public static Supplier<Item> axe(IItemTier tier) {
        return Builder.item((Item.Properties p) -> new AxeItem(tier, 5.0f, -2.0f, Builder.getDefaultProperties()));
    }

    public static Supplier<Item> sword(IItemTier tier) {
        return Builder.item((Item.Properties p) -> new SwordItem(tier, 3, -3.0f, Builder.getDefaultProperties()));
    }

    public static Item.Properties getDefaultProperties() {
        return new Item.Properties().func_200916_a(Tropicraft.TROPICRAFT_ITEM_GROUP);
    }

    public static Supplier<Item> fireArmor(EquipmentSlotType slotType) {
        return Builder.item((Item.Properties p) -> new FireArmorItem(slotType, Builder.getDefaultProperties().func_200917_a(1).func_200918_c(300)));
    }

    public static Supplier<Item> scaleArmor(EquipmentSlotType slotType) {
        return Builder.item((Item.Properties p) -> new ScaleArmorItem(slotType, Builder.getDefaultProperties().func_200917_a(1)));
    }

    public static Supplier<ScubaGogglesItem> scubaGoggles(ScubaType type) {
        return Builder.item((Item.Properties p) -> new ScubaGogglesItem(type, (Item.Properties)p));
    }

    public static Supplier<ScubaHarnessItem> scubaHarness(ScubaType type) {
        return Builder.item((Item.Properties p) -> new ScubaHarnessItem(type, (Item.Properties)p));
    }

    public static Supplier<ScubaFlippersItem> scubaFlippers(ScubaType type) {
        return Builder.item((Item.Properties p) -> new ScubaFlippersItem(type, (Item.Properties)p));
    }
}

