/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.common.item.ArmorMaterials;
import net.tropicraft.core.common.item.TropicraftArmorItem;
import net.tropicraft.core.common.item.TropicraftItems;

public class FireArmorItem
extends TropicraftArmorItem {
    public FireArmorItem(EquipmentSlotType slotType, Item.Properties properties) {
        super(ArmorMaterials.FIRE_ARMOR, slotType, properties);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (world.field_72995_K) {
            this.clientTick(player);
        } else {
            if (player.func_70027_ad()) {
                player.func_70066_B();
            }
            int factor = (int)(40.0 / (0.001 + (double)world.func_205052_D(player.func_233580_cy_())));
            if (world.func_82737_E() % (long)factor == 0L && world.func_175710_j(new BlockPos(MathHelper.func_76128_c((double)player.func_226277_ct_()), MathHelper.func_76128_c((double)(player.func_226278_cu_() + 1.0)), MathHelper.func_76128_c((double)player.func_226281_cx_())))) {
                stack.func_222118_a(-1, (LivingEntity)player, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(PlayerEntity player) {
        ParticleStatus particles;
        if (player.func_70090_H()) {
            return;
        }
        float range = 0.2f;
        float speed = 0.08f;
        Random rand = new Random();
        World worldRef = player.field_70170_p;
        int extraRand = 0;
        Vector3d motion = player.func_213322_ci();
        double plSpeed = Math.sqrt(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c);
        if (plSpeed < (double)0.1f) {
            extraRand = 7;
        }
        if ((particles = Minecraft.func_71410_x().field_71474_y.field_74362_aa) == ParticleStatus.MINIMAL) {
            return;
        }
        if (this == TropicraftItems.FIRE_BOOTS.get()) {
            BlockState block2;
            BlockState state;
            boolean onLava = false;
            boolean inLava = false;
            boolean x = false;
            boolean z = false;
            if (motion.field_72448_b < 0.0 && (state = player.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)(player.func_226277_ct_() + (double)x)), MathHelper.func_76128_c((double)(player.func_226278_cu_() - 2.0)), MathHelper.func_76128_c((double)(player.func_226281_cx_() + (double)z))))).func_185904_a() == Material.field_151587_i) {
                onLava = true;
            }
            if ((block2 = player.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)(player.func_226277_ct_() + (double)x)), MathHelper.func_76128_c((double)(player.func_226278_cu_() - 1.0)), MathHelper.func_76128_c((double)(player.func_226281_cx_() + (double)z))))).func_185904_a() == Material.field_151587_i) {
                inLava = true;
            }
            if (onLava && !inLava) {
                player.func_213317_d(motion.func_216372_d(1.0, 0.0, 1.0));
                player.func_230245_c_(true);
            }
            if (inLava && plSpeed < 0.4) {
                player.func_213317_d(motion.func_216372_d(1.5, 1.5, 1.5));
            }
            float look = player.field_70170_p.func_82737_E() * (long)(10 + (onLava ? 10 : 0));
            double dist = 1.0;
            double gatherX = player.func_226277_ct_();
            double gatherY = player.func_174813_aQ().field_72338_b;
            double gatherZ = player.func_226281_cx_();
            double motionX = rand.nextFloat() * speed - speed / 2.0f;
            double motionZ = rand.nextFloat() * speed - speed / 2.0f;
            int numFeetParticles = particles == ParticleStatus.DECREASED ? 2 : 11;
            for (int i = 0; i < numFeetParticles + (onLava ? 5 : 0); ++i) {
                motionX = -Math.sin(look / 180.0f * (float)Math.PI) * Math.cos(0.0) * ((double)speed + 0.1 * rand.nextDouble());
                motionZ = Math.cos(look / 180.0f * (float)Math.PI) * Math.cos(0.0) * ((double)speed + 0.1 * rand.nextDouble());
                BasicParticleType particle = ParticleTypes.field_197631_x;
                if (rand.nextInt(22) == 0) {
                    particle = ParticleTypes.field_197594_E;
                }
                if (!onLava && rand.nextInt(1 + extraRand) != 0) continue;
                Vector3d motion1 = player.func_213322_ci();
                player.field_70170_p.func_195594_a((IParticleData)particle, gatherX + (double)(rand.nextFloat() * range - range / 2.0f), gatherY + (double)(rand.nextFloat() * range - range / 2.0f), gatherZ + (double)(rand.nextFloat() * range - range / 2.0f), motion1.field_72450_a + motionX, (double)0.01f, motion1.field_72449_c + motionZ);
                player.field_70170_p.func_195594_a((IParticleData)particle, gatherX + (double)(rand.nextFloat() * range - range / 2.0f), gatherY + (double)(rand.nextFloat() * range - range / 2.0f), gatherZ + (double)(rand.nextFloat() * range - range / 2.0f), motion1.field_72450_a - motionX, (double)0.01f, motion1.field_72449_c - motionZ);
            }
        } else if (this == TropicraftItems.FIRE_LEGGINGS.get()) {
            BasicParticleType particle = ParticleTypes.field_197631_x;
            if (rand.nextInt(2) == 0) {
                particle = ParticleTypes.field_197594_E;
            }
            if (rand.nextInt(3 + extraRand) == 0) {
                player.field_70170_p.func_195594_a((IParticleData)particle, player.func_226277_ct_() + (double)(rand.nextFloat() * range - range / 2.0f), player.func_226278_cu_() - (double)0.8f + (double)(rand.nextFloat() * range - range / 2.0f), player.func_226281_cx_() + (double)(rand.nextFloat() * range - range / 2.0f), (double)(rand.nextFloat() * speed - speed / 2.0f), (double)-0.05f, (double)(rand.nextFloat() * speed - speed / 2.0f));
            }
        } else if (this == TropicraftItems.FIRE_CHESTPLATE.get()) {
            float look = -180.0f;
            double dist = 0.5;
            double gatherX = player.func_226277_ct_() + -Math.sin((player.field_70177_z + look) / 180.0f * (float)Math.PI) * Math.cos(player.field_70125_A / 180.0f * (float)Math.PI) * dist;
            double gatherZ = player.func_226281_cx_() + Math.cos((player.field_70177_z + look) / 180.0f * (float)Math.PI) * Math.cos(player.field_70125_A / 180.0f * (float)Math.PI) * dist;
            BasicParticleType particle = ParticleTypes.field_197631_x;
            if (rand.nextInt(2) == 0) {
                particle = ParticleTypes.field_197594_E;
            }
            if (rand.nextInt(1 + extraRand) == 0) {
                player.field_70170_p.func_195594_a((IParticleData)particle, gatherX + (double)(rand.nextFloat() * range - range / 2.0f), player.func_226278_cu_() - (double)0.4f + (double)(rand.nextFloat() * range - range / 2.0f), gatherZ + (double)(rand.nextFloat() * range - range / 2.0f), (double)(rand.nextFloat() * speed - speed / 2.0f), (double)-0.01f, (double)(rand.nextFloat() * speed - speed / 2.0f));
            }
        } else if (this == TropicraftItems.FIRE_HELMET.get()) {
            float look = -180.0f;
            double dist = 0.5;
            range = 2.0f;
            double gatherX = player.func_226277_ct_() + -Math.sin((player.field_70177_z + look) / 180.0f * (float)Math.PI) * Math.cos(player.field_70125_A / 180.0f * (float)Math.PI) * dist;
            double gatherZ = player.func_226281_cx_() + Math.cos((player.field_70177_z + look) / 180.0f * (float)Math.PI) * Math.cos(player.field_70125_A / 180.0f * (float)Math.PI) * dist;
            BasicParticleType particle = ParticleTypes.field_197631_x;
            if (rand.nextInt(2) == 0) {
                particle = ParticleTypes.field_197594_E;
            }
            if (rand.nextInt(2) == 0) {
                player.field_70170_p.func_195594_a((IParticleData)particle, gatherX + (double)(rand.nextFloat() * range - range / 2.0f), player.func_226278_cu_() + (double)0.7f, gatherZ + (double)(rand.nextFloat() * range - range / 2.0f), (double)(rand.nextFloat() * speed - speed / 2.0f), (double)-0.01f, (double)(rand.nextFloat() * speed - speed / 2.0f));
            }
        }
    }
}

