/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;
import net.tropicraft.core.common.item.IColoredItem;

public class FurnitureItem<T extends FurnitureEntity>
extends Item
implements IColoredItem {
    private final Supplier<? extends EntityType<T>> entityType;
    private final DyeColor color;

    public FurnitureItem(Item.Properties properties, Supplier<? extends EntityType<T>> entityType, DyeColor color) {
        super(properties);
        this.entityType = entityType;
        this.color = color;
    }

    @Override
    public int getColor(ItemStack stack, int pass) {
        return pass == 0 ? 0xFFFFFF : this.color.getColorValue();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity placer, Hand hand) {
        ItemStack heldItem = placer.func_184586_b(hand);
        BlockRayTraceResult rayTraceResult = FurnitureItem.func_219968_a((World)world, (PlayerEntity)placer, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return new ActionResult(ActionResultType.PASS, (Object)heldItem);
        }
        Vector3d lookvec = placer.func_70676_i(1.0f);
        List nearbyEntities = world.func_175674_a((Entity)placer, placer.func_174813_aQ().func_216361_a(lookvec.func_186678_a(5.0)).func_186662_g(1.0), EntityPredicates.field_180132_d);
        if (!nearbyEntities.isEmpty()) {
            Vector3d eyePosition = placer.func_174824_e(1.0f);
            for (Entity nearbyEnt : nearbyEntities) {
                AxisAlignedBB nearbyBB = nearbyEnt.func_174813_aQ().func_186662_g((double)nearbyEnt.func_70111_Y());
                if (!nearbyBB.func_72318_a(eyePosition)) continue;
                return new ActionResult(ActionResultType.PASS, (Object)heldItem);
            }
        }
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Vector3d hitVec = rayTraceResult.func_216347_e();
            FurnitureEntity entity = (FurnitureEntity)this.entityType.get().func_200721_a(world);
            entity.func_174828_a(new BlockPos(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c), 0.0f, 0.0f);
            entity.func_213317_d(Vector3d.field_186680_a);
            entity.setRotation(placer.field_70177_z + 180.0f);
            entity.setColor(this.color);
            if (!world.func_226665_a__((Entity)entity, entity.func_174813_aQ().func_186662_g(-0.1))) {
                return new ActionResult(ActionResultType.FAIL, (Object)heldItem);
            }
            if (!world.field_72995_K) {
                world.func_217376_c((Entity)entity);
            }
            if (!placer.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            placer.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return new ActionResult(ActionResultType.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(ActionResultType.PASS, (Object)heldItem);
    }
}

