/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.client.scuba.ModelScubaGear;
import net.tropicraft.core.common.item.ArmorMaterials;
import net.tropicraft.core.common.item.TropicraftArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaType;

public class ScubaArmorItem
extends TropicraftArmorItem {
    private final ScubaType type;

    public ScubaArmorItem(ScubaType type, EquipmentSlotType slotType, Item.Properties properties) {
        super(ArmorMaterials.SCUBA, slotType, properties);
        this.type = type;
    }

    public ScubaType getType() {
        return this.type;
    }

    public boolean providesAir() {
        return false;
    }

    public void tickAir(PlayerEntity player, EquipmentSlotType slot, ItemStack stack) {
    }

    public int addAir(int air, ItemStack stack) {
        return 0;
    }

    public int getRemainingAir(ItemStack stack) {
        return 0;
    }

    public int getMaxAir(ItemStack stack) {
        return 0;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return ScubaArmorItem.getArmorTexture(this.type).toString();
    }

    public static ResourceLocation getArmorTexture(ScubaType material) {
        return new ResourceLocation("tropicraft:textures/models/armor/scuba_gear_" + material.getTextureName() + ".png");
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemstack, EquipmentSlotType armorSlot, A _default) {
        ModelScubaGear armorModel;
        if (itemstack.func_190926_b()) {
            return null;
        }
        switch (armorSlot) {
            case HEAD: {
                armorModel = ModelScubaGear.HEAD;
                break;
            }
            case CHEST: {
                armorModel = ModelScubaGear.CHEST;
                break;
            }
            case FEET: {
                armorModel = ModelScubaGear.FEET;
                break;
            }
            default: {
                return null;
            }
        }
        armorModel.func_212843_a_(entityLiving, 0.0f, 0.0f, 1.0f);
        armorModel.field_228270_o_ = entityLiving.func_225608_bj_();
        armorModel.field_217114_e = entityLiving.func_70631_g_();
        armorModel.field_187076_m = entityLiving.func_184614_ca() != null ? BipedModel.ArmPose.BLOCK : BipedModel.ArmPose.EMPTY;
        return (A)((Object)armorModel);
    }
}

