/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.network.TropicraftPackets;
import net.tropicraft.core.common.network.message.MessageUpdateScubaData;

@Mod.EventBusSubscriber(modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScubaData
implements INBTSerializable<CompoundNBT> {
    @CapabilityInject(value=ScubaData.class)
    public static final Capability<ScubaData> CAPABILITY = null;
    private static final Set<ServerPlayerEntity> underwaterPlayers = Collections.newSetFromMap(new WeakHashMap());
    private long diveTime;
    private double maxDepth;
    private boolean dirty;

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(ScubaData.class, (Capability.IStorage)new Capability.IStorage<ScubaData>(){

            @Nullable
            public INBT writeNBT(Capability<ScubaData> capability, ScubaData instance, Direction side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<ScubaData> capability, ScubaData instance, Direction side, INBT nbt) {
                instance.deserializeNBT((CompoundNBT)nbt);
            }
        }, ScubaData::new);
    }

    @SubscribeEvent
    public static void onCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("tropicraft", "scuba_data"), (ICapabilityProvider)new ICapabilitySerializable<CompoundNBT>(){
                LazyOptional<ScubaData> data = LazyOptional.of(ScubaData::new);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CAPABILITY.orEmpty(cap, this.data);
                }

                public CompoundNBT serializeNBT() {
                    return ((ScubaData)this.data.orElseThrow(IllegalStateException::new)).serializeNBT();
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    ((ScubaData)this.data.orElseThrow(IllegalStateException::new)).deserializeNBT(nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack chestStack;
        Item chestItem;
        World world = event.player.field_70170_p;
        if (event.phase == TickEvent.Phase.END && (chestItem = (chestStack = event.player.func_184582_a(EquipmentSlotType.CHEST)).func_77973_b()) instanceof ScubaArmorItem) {
            LazyOptional data = event.player.getCapability(CAPABILITY);
            if (!world.field_72995_K) {
                underwaterPlayers.add((ServerPlayerEntity)event.player);
            }
            if (ScubaData.isUnderWater(event.player)) {
                data.ifPresent(d -> {
                    d.tick(event.player);
                    if (!world.field_72995_K) {
                        d.updateClient((ServerPlayerEntity)event.player, false);
                    }
                });
                ((ScubaArmorItem)chestItem).tickAir(event.player, EquipmentSlotType.CHEST, chestStack);
                if (!world.field_72995_K && world.func_82737_E() % 60L == 0L) {
                    Vector3d eyePos = event.player.func_174824_e(0.0f);
                    Vector3d motion = event.player.func_213322_ci();
                    Vector3d particlePos = eyePos.func_178787_e(motion.func_216371_e());
                    ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197612_e, particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), 4 + world.field_73012_v.nextInt(3), 0.25, 0.25, 0.25, motion.func_72433_c());
                }
            } else if (!world.field_72995_K && underwaterPlayers.remove(event.player)) {
                data.ifPresent(d -> d.updateClient((ServerPlayerEntity)event.player, false));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(CAPABILITY).ifPresent(d -> event.getPlayer().getCapability(CAPABILITY).ifPresent(d2 -> d2.copyFrom((ScubaData)d)));
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ScubaData.updateClient((PlayerEvent)event);
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        ScubaData.updateClient((PlayerEvent)event);
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ScubaData.updateClient((PlayerEvent)event);
    }

    private static void updateClient(PlayerEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            event.getPlayer().getCapability(CAPABILITY).ifPresent(d -> d.updateClient((ServerPlayerEntity)event.getPlayer(), true));
        }
    }

    public static boolean isUnderWater(PlayerEntity player) {
        BlockPos headPos = new BlockPos(player.func_174824_e(0.0f));
        return player.field_70170_p.func_204610_c(headPos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public static double getDepth(PlayerEntity player) {
        if (ScubaData.isUnderWater(player)) {
            int surface = TropicraftDimension.getSeaLevel((IWorldReader)player.field_70170_p);
            double depth = (double)surface - player.func_174824_e(0.0f).func_82617_b();
            return depth;
        }
        return 0.0;
    }

    void tick(PlayerEntity player) {
        ++this.diveTime;
        if (player.field_70170_p.func_82737_E() % 100L == 0L) {
            this.dirty = true;
        }
        this.updateMaxDepth(ScubaData.getDepth(player));
    }

    public long getDiveTime() {
        return this.diveTime;
    }

    void updateMaxDepth(double depth) {
        if (depth > this.maxDepth) {
            this.maxDepth = depth;
        }
    }

    public double getMaxDepth() {
        return this.maxDepth;
    }

    void updateClient(ServerPlayerEntity target, boolean force) {
        if (this.dirty || force) {
            TropicraftPackets.INSTANCE.send(PacketDistributor.PLAYER.with(() -> target), (Object)new MessageUpdateScubaData(this));
        }
    }

    public void copyFrom(ScubaData data) {
        this.diveTime = data.getDiveTime();
        this.maxDepth = data.getMaxDepth();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT ret = new CompoundNBT();
        ret.func_74772_a("diveTime", this.diveTime);
        ret.func_74780_a("maxDepth", this.maxDepth);
        return ret;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.diveTime = nbt.func_74763_f("diveTime");
        this.maxDepth = nbt.func_74769_h("maxDepth");
    }

    public void serializeBuffer(PacketBuffer buf) {
        buf.writeLong(this.diveTime);
        buf.writeDouble(this.maxDepth);
    }

    public void deserializeBuffer(PacketBuffer buf) {
        this.diveTime = buf.readLong();
        this.maxDepth = buf.readDouble();
    }
}

