/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.network.message;

import com.google.common.reflect.TypeToken;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.tropicraft.core.common.network.TropicraftMessage;

public abstract class MessageTileEntity<T extends TileEntity>
implements TropicraftMessage {
    protected long pos;
    @Deprecated
    protected int x;
    @Deprecated
    protected int y;
    @Deprecated
    protected int z;

    protected MessageTileEntity() {
    }

    protected MessageTileEntity(T tile) {
        this.pos = tile.func_174877_v().func_218275_a();
    }

    protected static void encode(MessageTileEntity<?> message, PacketBuffer buf) {
        buf.writeLong(message.pos);
    }

    protected static void decode(MessageTileEntity<?> message, PacketBuffer buf) {
        message.pos = buf.readLong();
        BlockPos bp = message.getPos();
        message.x = bp.func_177958_n();
        message.y = bp.func_177956_o();
        message.z = bp.func_177952_p();
    }

    public BlockPos getPos() {
        return BlockPos.func_218283_e((long)this.pos);
    }

    protected T getClientTileEntity() {
        return this.getTileEntity((World)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().field_71441_e));
    }

    protected T getTileEntity(World worldObj) {
        if (worldObj == null || !worldObj.func_175667_e(this.getPos())) {
            return null;
        }
        TileEntity te = worldObj.func_175625_s(this.getPos());
        if (te == null) {
            return null;
        }
        TypeToken teType = TypeToken.of(this.getClass()).resolveType(MessageTileEntity.class.getTypeParameters()[0]);
        if (teType.isSubtypeOf(te.getClass())) {
            return (T)te;
        }
        return null;
    }
}

