/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.volcano;

public enum VolcanoState {
    DORMANT(604800),
    SMOKING(600),
    RISING(3000),
    ERUPTING(3000),
    RETREATING(600);

    private final int duration;

    private VolcanoState(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public static int getTimeBefore(VolcanoState state) {
        switch (state) {
            case DORMANT: {
                return VolcanoState.RETREATING.duration;
            }
            case SMOKING: {
                return VolcanoState.DORMANT.duration;
            }
            case RISING: {
                return VolcanoState.SMOKING.duration;
            }
            case ERUPTING: {
                return VolcanoState.RISING.duration;
            }
            case RETREATING: {
                return VolcanoState.ERUPTING.duration;
            }
        }
        return 2000;
    }
}

