/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.crumbling;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlTextureUnit;
import com.jozufozu.flywheel.backend.instancing.InstanceManager;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.backend.state.RenderLayer;
import com.jozufozu.flywheel.core.Contexts;
import com.jozufozu.flywheel.core.crumbling.CrumblingGroup;
import com.jozufozu.flywheel.core.crumbling.CrumblingInstanceManager;
import com.jozufozu.flywheel.core.crumbling.CrumblingProgram;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import com.jozufozu.flywheel.util.Lazy;
import com.jozufozu.flywheel.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class CrumblingRenderer {
    private static final Lazy<State> STATE;
    private static final Lazy.KillSwitch<State> INVALIDATOR;

    public static void renderBreaking(ClientWorld world, Matrix4f viewProjection, double cameraX, double cameraY, double cameraZ) {
        if (!Backend.getInstance().canUseInstancing((World)world)) {
            return;
        }
        Int2ObjectMap<List<TileEntity>> activeStages = CrumblingRenderer.getActiveStageTiles(world);
        if (activeStages.isEmpty()) {
            return;
        }
        State state = STATE.get();
        RenderType layer = (RenderType)ModelBakery.field_229320_k_.get(0);
        InstanceManager renderer = state.instanceManager;
        TextureManager textureManager = Minecraft.func_71410_x().field_71446_o;
        ActiveRenderInfo info = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        MaterialManager materials = state.materialManager;
        layer.func_228547_a_();
        for (Int2ObjectMap.Entry stage : activeStages.int2ObjectEntrySet()) {
            int i = stage.getIntKey();
            Texture breaking = textureManager.func_229267_b_((ResourceLocation)ModelBakery.field_229319_j_.get(i));
            if (breaking == null) continue;
            ((List)stage.getValue()).forEach(renderer::add);
            renderer.beginFrame(info);
            GlTextureUnit.T4.makeActive();
            GL11.glBindTexture((int)3553, (int)breaking.func_110552_b());
            materials.render(RenderLayer.SOLID, viewProjection, cameraX, cameraY, cameraZ);
            renderer.invalidate();
        }
        layer.func_228549_b_();
        GlTextureUnit.T0.makeActive();
        Texture breaking = textureManager.func_229267_b_((ResourceLocation)ModelBakery.field_229319_j_.get(0));
        if (breaking != null) {
            GL11.glBindTexture((int)3553, (int)breaking.func_110552_b());
        }
    }

    private static Int2ObjectMap<List<TileEntity>> getActiveStageTiles(ClientWorld world) {
        Long2ObjectMap breakingProgressions = Minecraft.func_71410_x().field_71438_f.field_228407_B_;
        Int2ObjectArrayMap breakingEntities = new Int2ObjectArrayMap();
        for (Long2ObjectMap.Entry entry : breakingProgressions.long2ObjectEntrySet()) {
            BlockPos breakingPos = BlockPos.func_218283_e((long)entry.getLongKey());
            SortedSet progresses = (SortedSet)entry.getValue();
            if (progresses == null || progresses.isEmpty()) continue;
            int blockDamage = ((DestroyBlockProgress)progresses.last()).func_73106_e();
            TileEntity tileEntity = world.func_175625_s(breakingPos);
            if (tileEntity == null) continue;
            List tileEntities = (List)breakingEntities.computeIfAbsent(blockDamage, $ -> new ArrayList());
            tileEntities.add(tileEntity);
        }
        return breakingEntities;
    }

    @SubscribeEvent
    public static void onReloadRenderers(ReloadRenderersEvent event) {
        ClientWorld world = event.getWorld();
        if (Backend.getInstance().canUseInstancing() && world != null) {
            CrumblingRenderer.reset();
        }
    }

    public static void reset() {
        INVALIDATOR.killValue();
    }

    static {
        Pair<Lazy<State>, Lazy.KillSwitch<State>> state = Lazy.ofKillable(() -> new State(), rec$ -> ((State)rec$).kill());
        STATE = state.getFirst();
        INVALIDATOR = state.getSecond();
    }

    private static class State {
        private final MaterialManager<CrumblingProgram> materialManager = MaterialManager.builder(Contexts.CRUMBLING).setGroupFactory(CrumblingGroup::new).build();
        private final InstanceManager<TileEntity> instanceManager = new CrumblingInstanceManager(this.materialManager);

        private State() {
        }

        private void kill() {
            this.materialManager.delete();
            this.instanceManager.invalidate();
        }
    }
}

