/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.world.IWorld;

public class WorldAttached<T> {
    private final Map<IWorld, T> attached;
    private final Function<IWorld, T> factory;

    public WorldAttached(Function<IWorld, T> factory) {
        this.factory = factory;
        this.attached = new WeakHashMap<IWorld, T>();
    }

    @Nonnull
    public T get(IWorld world) {
        T t = this.attached.get(world);
        if (t != null) {
            return t;
        }
        T entry = this.factory.apply(world);
        this.put(world, entry);
        return entry;
    }

    public void put(IWorld world, T entry) {
        this.attached.put(world, entry);
    }

    @Nonnull
    public T replace(IWorld world) {
        this.attached.remove(world);
        return this.get(world);
    }

    @Nonnull
    public T replace(IWorld world, Consumer<T> finalizer) {
        T remove = this.attached.remove(world);
        if (remove != null) {
            finalizer.accept(remove);
        }
        return this.get(world);
    }

    public void empty(BiConsumer<IWorld, T> finalizer) {
        this.attached.forEach(finalizer);
        this.attached.clear();
    }

    public void empty(Consumer<T> finalizer) {
        this.attached.values().forEach(finalizer);
        this.attached.clear();
    }
}

