/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SixWayBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public final class PianguasBlock
extends Block
implements IWaterLoggable {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final BooleanProperty UP = SixWayBlock.field_196496_z;
    private static final BooleanProperty DOWN = SixWayBlock.field_196489_A;
    private static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    private static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    private static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    private static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    public static final Map<Direction, BooleanProperty> ATTACHMENTS = SixWayBlock.field_196491_B;
    private static final VoxelShape UP_SHAPE = Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Direction[] DIRECTIONS = Direction.values();
    private final Map<BlockState, VoxelShape> stateToShape;

    public PianguasBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.stateToShape = this.field_176227_L.func_177619_a().stream().collect(Collectors.toMap(Function.identity(), PianguasBlock::getShapeForState));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.stateToShape.get(state);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return PianguasBlock.hasAttachments(PianguasBlock.removeInvalidAttachments(state, (IBlockReader)world, pos));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        BlockState currentState = world.func_180495_p(pos = context.func_195995_a());
        boolean extend = currentState.func_203425_a((Block)this);
        BlockState placementState = extend ? currentState : this.func_176223_P();
        Fluid fluid = world.func_204610_c(pos).func_206886_c();
        placementState = (BlockState)placementState.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.field_204546_a));
        for (Direction direction : context.func_196009_e()) {
            boolean replacing;
            BooleanProperty property = PianguasBlock.getPropertyFor(direction);
            boolean bl = replacing = extend && (Boolean)currentState.func_177229_b((Property)property) != false;
            if (replacing || !PianguasBlock.canAttachTo((IBlockReader)world, pos.func_177972_a(direction), direction)) continue;
            return (BlockState)placementState.func_206870_a((Property)property, (Comparable)Boolean.valueOf(true));
        }
        return extend ? placementState : null;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState adjacentState, IWorld world, BlockPos currentPos, BlockPos adjacentPos) {
        BlockState newState = PianguasBlock.removeInvalidAttachments(state, (IBlockReader)world, currentPos);
        if (!PianguasBlock.hasAttachments(newState)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return newState;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        BlockState currentState = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (currentState.func_203425_a((Block)this)) {
            return PianguasBlock.getAttachmentCount(currentState) < ATTACHMENTS.size();
        }
        return super.func_196253_a(state, context);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)EAST, state.func_177229_b((Property)WEST))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)NORTH))).func_206870_a((Property)WEST, state.func_177229_b((Property)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)EAST))).func_206870_a((Property)EAST, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, state.func_177229_b((Property)NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)WEST))).func_206870_a((Property)EAST, state.func_177229_b((Property)NORTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)EAST))).func_206870_a((Property)WEST, state.func_177229_b((Property)SOUTH));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a((Property)EAST, state.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, state.func_177229_b((Property)EAST));
            }
        }
        return super.func_185471_a(state, mirror);
    }

    public static boolean canAttachTo(IBlockReader world, BlockPos attachPos, Direction direction) {
        BlockState attachState = world.func_180495_p(attachPos);
        VoxelShape attachShape = attachState.func_196952_d(world, attachPos);
        return Block.func_208061_a((VoxelShape)attachShape, (Direction)direction.func_176734_d());
    }

    private static BlockState removeInvalidAttachments(BlockState state, IBlockReader world, BlockPos pos) {
        for (Direction direction : DIRECTIONS) {
            BlockPos attachPos;
            BooleanProperty property = PianguasBlock.getPropertyFor(direction);
            if (!((Boolean)state.func_177229_b((Property)property)).booleanValue() || PianguasBlock.canAttachTo(world, attachPos = pos.func_177972_a(direction), direction)) continue;
            state = (BlockState)state.func_206870_a((Property)property, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    private static VoxelShape getShapeForState(BlockState state) {
        VoxelShape shape = VoxelShapes.func_197880_a();
        if (((Boolean)state.func_177229_b((Property)UP)).booleanValue()) {
            shape = UP_SHAPE;
        }
        if (((Boolean)state.func_177229_b((Property)DOWN)).booleanValue()) {
            shape = DOWN_SHAPE;
        }
        if (((Boolean)state.func_177229_b((Property)NORTH)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.func_177229_b((Property)SOUTH)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.func_177229_b((Property)EAST)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        if (((Boolean)state.func_177229_b((Property)WEST)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        return shape;
    }

    private static boolean hasAttachments(BlockState state) {
        return PianguasBlock.getAttachmentCount(state) > 0;
    }

    private static int getAttachmentCount(BlockState state) {
        int count = 0;
        for (BooleanProperty property : ATTACHMENTS.values()) {
            if (!((Boolean)state.func_177229_b((Property)property)).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    private static BooleanProperty getPropertyFor(Direction side) {
        return ATTACHMENTS.get(side);
    }
}

