/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;

public final class ReedsBlock
extends Block
implements IWaterLoggable,
IPlantable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<Type> TYPE = EnumProperty.func_177709_a((String)"type", Type.class);
    private static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public ReedsBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(TYPE, (Comparable)((Object)Type.SINGLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        FluidState fluid = world.func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)this.getAppropriateTypeAt((IWorld)world, context.func_195995_a())))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (!state.func_196955_c((IWorldReader)world, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)this.getAppropriateTypeAt(world, currentPos)));
    }

    private Type getAppropriateTypeAt(IWorld world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177984_a()).func_203425_a((Block)this)) {
            return Type.BOTTOM;
        }
        return world.func_180495_p(pos.func_177977_b()).func_203425_a((Block)this) ? Type.TOP : Type.SINGLE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos groundPos = pos.func_177977_b();
        BlockState growOn = world.func_180495_p(groundPos);
        if (growOn.canSustainPlant((IBlockReader)world, groundPos, Direction.UP, (IPlantable)this)) {
            return true;
        }
        return growOn.func_177230_c() == this || this.canGrowOn(growOn);
    }

    private boolean canGrowOn(BlockState state) {
        return state.func_203425_a(Blocks.field_196658_i) || state.func_235714_a_((ITag)BlockTags.field_203436_u) || state.func_235714_a_((ITag)Tags.Blocks.DIRT) || state.func_235714_a_((ITag)Tags.Blocks.GRAVEL) || state.func_203425_a(Blocks.field_150435_aG);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, TYPE});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.func_176223_P();
    }

    public static enum Type implements IStringSerializable
    {
        SINGLE("single", "reeds_top_short"),
        BOTTOM("bottom", "reeds_bottom"),
        TOP("top", "reeds_top_tall", "reeds_top_short");

        private final String key;
        private final String[] textures;

        private Type(String key, String ... textures) {
            this.key = key;
            this.textures = textures;
        }

        public String[] getTextures() {
            return this.textures;
        }

        public String func_176610_l() {
            return this.key;
        }
    }
}

