/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public final class RopeBlock
extends Block
implements IWaterLoggable {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final BooleanProperty KNOT = BooleanProperty.func_177716_a((String)"knot");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public RopeBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)KNOT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !this.canHangFrom((IWorldReader)world, facingPos, facingState)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)state.func_206870_a((Property)KNOT, (Comparable)Boolean.valueOf(!facingState.func_203425_a((Block)this)));
        }
        return state;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        if (this.canHangAt((IWorldReader)world, pos = context.func_195995_a())) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)KNOT, (Comparable)Boolean.valueOf(this.isKnottedAt((IWorldReader)world, pos)))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return this.canHangAt(world, pos);
    }

    private boolean canHangAt(IWorldReader world, BlockPos pos) {
        BlockPos attachPos = pos.func_177984_a();
        BlockState attachState = world.func_180495_p(attachPos);
        return this.canHangFrom(world, attachPos, attachState);
    }

    private boolean canHangFrom(IWorldReader world, BlockPos attachPos, BlockState attachState) {
        return attachState.func_203425_a((Block)this) || Block.func_220055_a((IWorldReader)world, (BlockPos)attachPos, (Direction)Direction.DOWN) || attachState.func_235714_a_((ITag)BlockTags.field_206952_E);
    }

    private boolean isKnottedAt(IWorldReader world, BlockPos pos) {
        return !world.func_180495_p(pos.func_177977_b()).func_203425_a((Block)this);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{KNOT, WATERLOGGED});
    }
}

