/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block.entity;

import com.lovetropics.extras.entity.ExtendedCreatureEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MobControllerBlockEntity
extends TileEntity
implements ITickableTileEntity {
    public boolean loadState = true;
    public final List<UUID> uuids = new ArrayList<UUID>();
    public final Map<UUID, EntityType<?>> types = new HashMap();
    public final Map<UUID, Vector3d> positions = new HashMap<UUID, Vector3d>();

    public MobControllerBlockEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        ListNBT mobUuids = nbt.func_150295_c("Mobs", 10);
        this.uuids.clear();
        for (INBT mobNbt : mobUuids) {
            CompoundNBT compoundNBT = (CompoundNBT)mobNbt;
            UUID uuid = compoundNBT.func_186857_a("UUID");
            String type = compoundNBT.func_74779_i("Type");
            ListNBT pos = compoundNBT.func_150295_c("Pos", 6);
            EntityType entityType = (EntityType)Registry.field_212629_r.func_241873_b(new ResourceLocation(type)).get();
            this.uuids.add(uuid);
            this.types.put(uuid, entityType);
            this.positions.put(uuid, new Vector3d(pos.func_150309_d(0), pos.func_150309_d(1), pos.func_150309_d(2)));
        }
        this.loadState = nbt.func_74767_n("LoadState");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ListNBT mobs = new ListNBT();
        for (UUID uuid : this.uuids) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_186854_a("UUID", uuid);
            compoundNBT.func_74778_a("Type", EntityType.func_200718_a(this.types.get(uuid)).toString());
            Vector3d pos = this.positions.get(uuid);
            compoundNBT.func_218657_a("Pos", (INBT)this.newDoubleNBTList(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c));
            mobs.add((Object)compoundNBT);
        }
        compound.func_218657_a("Mobs", (INBT)mobs);
        compound.func_74757_a("LoadState", this.loadState);
        return compound;
    }

    protected ListNBT newDoubleNBTList(double ... numbers) {
        ListNBT listnbt = new ListNBT();
        for (double d0 : numbers) {
            listnbt.add((Object)DoubleNBT.func_229684_a_((double)d0));
        }
        return listnbt;
    }

    public void addEntity(Entity entity) {
        if (entity instanceof ExtendedCreatureEntity) {
            ExtendedCreatureEntity ex = (ExtendedCreatureEntity)entity;
            ex.linkToBlockEntity(this);
            UUID uuid = entity.func_110124_au();
            this.uuids.add(uuid);
            this.types.put(uuid, entity.func_200600_R());
            this.positions.put(uuid, entity.func_213303_ch());
        }
    }

    public void func_73660_a() {
        block7: {
            PlayerEntity player;
            BlockPos pos;
            ServerWorld serverWorld;
            World world;
            block8: {
                world = this.func_145831_w();
                if (world == null) {
                    return;
                }
                if (world.func_201670_d()) break block7;
                serverWorld = (ServerWorld)world;
                long ticks = world.func_82737_E();
                if (this.loadState && ticks % 5L == 0L) {
                    for (UUID uuid : this.uuids) {
                        Entity entity = serverWorld.func_217461_a(uuid);
                        if (entity == null) continue;
                        this.positions.put(uuid, entity.func_213303_ch());
                    }
                }
                if (ticks % 20L != 0L) break block7;
                pos = this.func_174877_v();
                player = world.func_190525_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 32.0, EntityPredicates.field_180132_d);
                if (!this.loadState) break block8;
                if (player != null) break block7;
                this.loadState = false;
                for (UUID uuid : this.uuids) {
                    Entity entity = serverWorld.func_217461_a(uuid);
                    if (entity == null) continue;
                    entity.func_70106_y();
                }
                break block7;
            }
            if (player != null) {
                this.loadState = true;
                for (UUID uuid : this.uuids) {
                    Entity entity = this.types.get(uuid).func_200721_a((World)serverWorld);
                    Vector3d mobPos = this.positions.get(uuid);
                    if (entity == null) continue;
                    entity.func_70012_b(mobPos.func_82615_a(), mobPos.func_82617_b(), mobPos.func_82616_c(), 0.0f, 0.0f);
                    entity.func_184221_a(uuid);
                    world.func_217376_c(entity);
                    if (entity instanceof MobEntity) {
                        ((MobEntity)entity).func_213386_a((IServerWorld)serverWorld, world.func_175649_E(pos), SpawnReason.MOB_SUMMONED, null, null);
                    }
                    if (!(entity instanceof ExtendedCreatureEntity)) continue;
                    ((ExtendedCreatureEntity)entity).linkToBlockEntity(this);
                }
            }
        }
    }
}

