/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin.client.perf;

import com.lovetropics.extras.perf.LossyLightCache;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraft/client/renderer/BlockModelRenderer$Cache"})
public class BlockModelRendererCacheMixin {
    @Shadow
    private boolean field_222898_a;
    @Unique
    private final LossyLightCache.Packed fastPackedLightCache = new LossyLightCache.Packed(128);
    @Unique
    private final LossyLightCache.Brightness fastBrightnessCache = new LossyLightCache.Brightness(128);

    @Inject(method={"disable()V"}, at={@At(value="RETURN")})
    private void disable(CallbackInfo ci) {
        this.fastPackedLightCache.clear();
        this.fastBrightnessCache.clear();
    }

    @Overwrite
    public int func_228810_a_(BlockState state, IBlockDisplayReader world, BlockPos pos) {
        if (!this.field_222898_a) {
            return WorldRenderer.func_228420_a_((IBlockDisplayReader)world, (BlockState)state, (BlockPos)pos);
        }
        LossyLightCache.Packed cache = this.fastPackedLightCache;
        long posKey = pos.func_218275_a();
        int light = cache.get(posKey);
        if (light != Integer.MAX_VALUE) {
            return light;
        }
        light = WorldRenderer.func_228420_a_((IBlockDisplayReader)world, (BlockState)state, (BlockPos)pos);
        cache.put(posKey, light);
        return light;
    }

    @Overwrite
    public float func_228811_b_(BlockState state, IBlockDisplayReader world, BlockPos pos) {
        if (!this.field_222898_a) {
            return state.func_215703_d((IBlockReader)world, pos);
        }
        LossyLightCache.Brightness cache = this.fastBrightnessCache;
        long posKey = pos.func_218275_a();
        float brightness = cache.get(posKey);
        if (!Float.isNaN(brightness)) {
            return brightness;
        }
        brightness = state.func_215703_d((IBlockReader)world, pos);
        cache.put(posKey, brightness);
        return brightness;
    }
}

