/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin.client.perf;

import com.lovetropics.extras.perf.BiomeColorSampler;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.palette.PalettedContainer;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.level.ColorResolver;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkRenderCache.class})
public abstract class ChunkRenderCacheMixin {
    @Shadow
    @Final
    protected World field_212408_i;
    @Shadow
    @Final
    protected BlockState[] field_217340_h;
    @Shadow
    @Final
    protected FluidState[] field_217341_i;
    @Unique
    private ChunkPos chunkPos;
    @Unique
    private BiomeColorSampler biomeColorSampler;
    @Unique
    private BiomeColorSampler.Buffer grassColors;
    @Unique
    private BiomeColorSampler.Buffer waterColors;
    @Unique
    private BiomeColorSampler.Buffer foliageColors;

    @Shadow
    protected abstract int func_217339_a(int var1, int var2, int var3);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(World world, int chunkStartX, int chunkStartZ, Chunk[][] chunks, BlockPos startPos, BlockPos endPos, CallbackInfo ci) {
        BlockPos centerPos = new BlockPos((startPos.func_177958_n() + endPos.func_177958_n()) / 2, (startPos.func_177956_o() + endPos.func_177956_o()) / 2, (startPos.func_177952_p() + endPos.func_177952_p()) / 2);
        this.chunkPos = new ChunkPos(centerPos.func_177958_n() >> 4, centerPos.func_177952_p() >> 4);
        this.fillBlockData(world, chunkStartX, chunkStartZ, chunks, startPos, endPos);
    }

    private void fillBlockData(World world, int minChunkX, int minChunkZ, Chunk[][] chunks, BlockPos startPos, BlockPos endPos) {
        int minChunkY = 0;
        int maxChunkX = minChunkX + chunks.length;
        int maxChunkY = world.func_217301_I() >> 4;
        int maxChunkZ = minChunkZ + chunks[0].length;
        Object[] blockStates = this.field_217340_h;
        Object[] fluidStates = this.field_217341_i;
        Arrays.fill(blockStates, Blocks.field_150350_a.func_176223_P());
        Arrays.fill(fluidStates, Fluids.field_204541_a.func_207188_f());
        for (int chunkZ = minChunkZ; chunkZ < maxChunkZ; ++chunkZ) {
            int minBlockZ = Math.max(chunkZ << 4, startPos.func_177952_p());
            int maxBlockZ = Math.min((chunkZ << 4) + 15, endPos.func_177952_p());
            for (int chunkX = minChunkX; chunkX < maxChunkX; ++chunkX) {
                int minBlockX = Math.max(chunkX << 4, startPos.func_177958_n());
                int maxBlockX = Math.min((chunkX << 4) + 15, endPos.func_177958_n());
                Chunk chunk = chunks[chunkX - minChunkX][chunkZ - minChunkZ];
                ChunkSection[] sections = chunk.func_76587_i();
                for (int chunkY = minChunkY; chunkY < maxChunkY; ++chunkY) {
                    ChunkSection section = sections[chunkY];
                    if (section == null || section.func_76663_a()) continue;
                    PalettedContainer blocks = section.func_186049_g();
                    int minBlockY = Math.max(chunkY << 4, startPos.func_177956_o());
                    int maxBlockY = Math.min((chunkY << 4) + 15, endPos.func_177956_o());
                    for (int y = minBlockY; y <= maxBlockY; ++y) {
                        for (int z = minBlockZ; z <= maxBlockZ; ++z) {
                            for (int x = minBlockX; x <= maxBlockX; ++x) {
                                BlockState block = (BlockState)blocks.func_186016_a(x & 0xF, y & 0xF, z & 0xF);
                                FluidState fluid = block.func_204520_s();
                                int index = this.func_217339_a(x, y, z);
                                blockStates[index] = block;
                                fluidStates[index] = fluid;
                            }
                        }
                    }
                }
            }
        }
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/BlockPos;getAllInBoxMutable(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)Ljava/lang/Iterable;"))
    private Iterable<BlockPos> initBlockAndFluidCaches(BlockPos firstPos, BlockPos secondPos) {
        return Collections.emptyList();
    }

    @Overwrite
    public int func_225525_a_(BlockPos pos, ColorResolver resolver) {
        if (resolver == BiomeColors.field_180291_a) {
            BiomeColorSampler.Buffer grassColors = this.grassColors;
            if (grassColors == null) {
                this.grassColors = grassColors = this.getBiomeColorSampler().sample(BiomeColors.field_180291_a);
            }
            return grassColors.get(pos);
        }
        if (resolver == BiomeColors.field_180290_c) {
            BiomeColorSampler.Buffer waterColors = this.waterColors;
            if (waterColors == null) {
                this.waterColors = waterColors = this.getBiomeColorSampler().sample(BiomeColors.field_180290_c);
            }
            return waterColors.get(pos);
        }
        if (resolver == BiomeColors.field_180289_b) {
            BiomeColorSampler.Buffer foliageColors = this.foliageColors;
            if (foliageColors == null) {
                this.foliageColors = foliageColors = this.getBiomeColorSampler().sample(BiomeColors.field_180289_b);
            }
            return foliageColors.get(pos);
        }
        return this.field_212408_i.func_225525_a_(pos, resolver);
    }

    @Unique
    private BiomeColorSampler getBiomeColorSampler() {
        BiomeColorSampler sampler = this.biomeColorSampler;
        if (sampler == null) {
            this.biomeColorSampler = sampler = BiomeColorSampler.create(this.field_212408_i, this.chunkPos);
        }
        return sampler;
    }
}

