/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin.client.perf;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraftforge.registries.IRegistryDelegate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderTypeLookup.class})
public class RenderTypeLookupMixin {
    @Shadow
    private static boolean field_228388_c_;
    @Shadow
    @Final
    @Deprecated
    private static Map<Block, RenderType> field_228386_a_;
    @Shadow
    @Final
    @Deprecated
    private static Map<Fluid, RenderType> field_228387_b_;
    @Shadow(remap=false)
    @Mutable
    @Final
    private static Map<IRegistryDelegate<Block>, Predicate<RenderType>> blockRenderChecks;
    @Shadow(remap=false)
    @Mutable
    @Final
    private static Map<IRegistryDelegate<Fluid>, Predicate<RenderType>> fluidRenderChecks;
    @Unique
    private static final StampedLock RENDER_CHECK_LOCK;
    @Unique
    private static final Predicate<RenderType> SOLID_PREDICATE;

    @Inject(method={"<clinit>"}, at={@At(value="RETURN")})
    private static void init(CallbackInfo ci) {
        Reference2ObjectOpenHashMap blockMap = new Reference2ObjectOpenHashMap();
        Reference2ObjectOpenHashMap fluidMap = new Reference2ObjectOpenHashMap();
        blockMap.defaultReturnValue(SOLID_PREDICATE);
        fluidMap.defaultReturnValue(SOLID_PREDICATE);
        blockRenderChecks = blockMap;
        fluidRenderChecks = fluidMap;
        field_228386_a_.forEach(RenderTypeLookup::setRenderLayer);
        field_228387_b_.forEach(RenderTypeLookup::setRenderLayer);
    }

    @Redirect(method={"<clinit>"}, at=@At(value="INVOKE", target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V"))
    private static void registerRenderLayers(Map instance, BiConsumer consumer) {
    }

    @Overwrite(remap=false)
    public static boolean canRenderInLayer(BlockState state, RenderType type) {
        Block block = state.func_177230_c();
        if (block instanceof LeavesBlock) {
            return field_228388_c_ ? type == RenderType.func_228641_d_() : type == RenderType.func_228639_c_();
        }
        return RenderTypeLookupMixin.canRenderInLayer(type, blockRenderChecks, block.delegate);
    }

    @Overwrite(remap=false)
    public static boolean canRenderInLayer(FluidState fluid, RenderType type) {
        return RenderTypeLookupMixin.canRenderInLayer(type, fluidRenderChecks, fluid.func_206886_c().delegate);
    }

    @Unique
    private static <T> boolean canRenderInLayer(RenderType type, Map<T, Predicate<RenderType>> map, T key) {
        Predicate<RenderType> predicate;
        StampedLock lock = RENDER_CHECK_LOCK;
        long stamp = lock.tryOptimisticRead();
        if (stamp != 0L) {
            predicate = map.get(key);
            if (lock.validate(stamp)) {
                return predicate.test(type);
            }
        }
        stamp = lock.readLock();
        predicate = map.get(key);
        lock.unlockRead(stamp);
        return predicate.test(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    public static synchronized void setRenderLayer(Block block, Predicate<RenderType> predicate) {
        long stamp = RENDER_CHECK_LOCK.writeLock();
        try {
            blockRenderChecks.put((IRegistryDelegate<Block>)block.delegate, predicate);
        }
        finally {
            RENDER_CHECK_LOCK.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    public static synchronized void setRenderLayer(Fluid fluid, Predicate<RenderType> predicate) {
        long stamp = RENDER_CHECK_LOCK.writeLock();
        try {
            fluidRenderChecks.put((IRegistryDelegate<Fluid>)fluid.delegate, predicate);
        }
        finally {
            RENDER_CHECK_LOCK.unlockWrite(stamp);
        }
    }

    static {
        RENDER_CHECK_LOCK = new StampedLock();
        SOLID_PREDICATE = type -> type == RenderType.func_228639_c_();
    }
}

