/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin.perf;

import com.lovetropics.extras.perf.LossyChunkCache;
import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketManager;
import net.minecraft.world.server.TicketType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerChunkProvider.class})
public abstract class ServerChunkProviderMixin {
    @Shadow
    @Final
    public ChunkManager field_217237_a;
    @Shadow
    @Final
    private Thread field_217241_g;
    @Shadow
    @Final
    private ServerChunkProvider.ChunkExecutor field_217243_i;
    @Shadow
    @Final
    private TicketManager field_217240_d;
    @Shadow
    @Final
    public ServerWorld field_73251_h;
    @Unique
    private final LossyChunkCache fastCache = new LossyChunkCache(32);

    @Inject(method={"invalidateCaches"}, at={@At(value="HEAD")})
    private void invalidateCaches(CallbackInfo ci) {
        this.fastCache.clear();
    }

    @Nullable
    @Overwrite
    public IChunk func_212849_a_(int x, int z, ChunkStatus status, boolean load) {
        if (load) {
            if (Thread.currentThread() != this.field_217241_g) {
                return this.getOrLoadChunkOffThread(x, z, status);
            }
            return this.getOrLoadChunkOnThread(x, z, status);
        }
        return this.getExistingChunk(x, z, status);
    }

    private IChunk getOrLoadChunkOnThread(int x, int z, ChunkStatus status) {
        Either<IChunk, ChunkHolder.IChunkLoadingError> result;
        IChunk cached = this.fastCache.get(x, z, status);
        if (cached != null) {
            return cached;
        }
        ChunkHolder holder = this.func_217213_a(ChunkPos.func_77272_a((int)x, (int)z));
        IChunk chunk = this.getExistingChunkFor(holder, status);
        if (chunk == null && (chunk = (IChunk)(result = this.joinFuture(this.loadChunk(x, z, status))).left().orElse(null)) == null) {
            throw new IllegalStateException("Chunk not there when requested: " + result.right().orElse(null));
        }
        this.fastCache.put(x, z, status, chunk);
        return chunk;
    }

    private <T> T joinFuture(CompletableFuture<T> future) {
        if (!future.isDone()) {
            this.field_217243_i.func_213161_c(future::isDone);
        }
        return future.join();
    }

    private IChunk getOrLoadChunkOffThread(int x, int z, ChunkStatus status) {
        Either result = (Either)CompletableFuture.supplyAsync(() -> this.loadChunk(x, z, status), (Executor)this.field_217243_i).join().join();
        IChunk chunk = result.left().orElse(null);
        if (chunk != null) {
            return chunk;
        }
        throw new IllegalStateException("Chunk not there when requested: " + result.right().orElse(null));
    }

    private CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> loadChunk(int x, int z, ChunkStatus status) {
        long chunkKey = ChunkPos.func_77272_a((int)x, (int)z);
        ChunkHolder holder = this.func_217213_a(chunkKey);
        int level = ServerChunkProviderMixin.getLevelForStatus(status);
        ChunkPos chunkPos = new ChunkPos(x, z);
        this.field_217240_d.func_219356_a(TicketType.field_219494_g, chunkPos, level, (Object)chunkPos);
        if (!ServerChunkProviderMixin.isValidForLevel(holder, level)) {
            this.func_217235_l();
            holder = this.func_217213_a(chunkKey);
            if (!ServerChunkProviderMixin.isValidForLevel(holder, level)) {
                throw new IllegalStateException("No chunk holder after ticket has been added");
            }
        }
        return holder.func_219276_a(status, this.field_217237_a);
    }

    @Overwrite
    @Nullable
    public Chunk func_225313_a(int x, int z) {
        return (Chunk)this.getExistingChunk(x, z, ChunkStatus.field_222617_m);
    }

    private IChunk getExistingChunk(int x, int z, ChunkStatus status) {
        if (Thread.currentThread() != this.field_217241_g) {
            return this.loadExistingChunk(x, z, status);
        }
        IChunk cached = this.fastCache.get(x, z, status);
        if (cached != null) {
            return cached;
        }
        IChunk chunk = this.loadExistingChunk(x, z, status);
        this.fastCache.put(x, z, status, chunk);
        return chunk;
    }

    @Nullable
    private IChunk loadExistingChunk(int x, int z, ChunkStatus status) {
        ChunkHolder holder = this.func_217213_a(ChunkPos.func_77272_a((int)x, (int)z));
        return this.getExistingChunkFor(holder, status);
    }

    @Nullable
    private IChunk getExistingChunkFor(@Nullable ChunkHolder holder, ChunkStatus status) {
        if (ServerChunkProviderMixin.isValidForStatus(holder, status)) {
            CompletableFuture future = holder.func_219301_a(status);
            return future.getNow(ChunkHolder.field_219306_a).left().orElse(null);
        }
        return null;
    }

    @Overwrite
    public boolean func_73149_a(int x, int z) {
        return this.getExistingChunk(x, z, ChunkStatus.field_222617_m) != null;
    }

    @Overwrite
    private boolean func_222872_a(long pos, Function<ChunkHolder, CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>>> function) {
        ChunkHolder holder = this.func_217213_a(pos);
        return holder != null && !function.apply(holder).getNow((Either<Chunk, ChunkHolder.IChunkLoadingError>)ChunkHolder.field_219308_c).right().isPresent();
    }

    private static boolean isValidForStatus(ChunkHolder holder, ChunkStatus status) {
        return holder != null && holder.func_219299_i() <= ServerChunkProviderMixin.getLevelForStatus(status);
    }

    private static int getLevelForStatus(ChunkStatus status) {
        return 33 + ChunkStatus.func_222599_a((ChunkStatus)status);
    }

    private static boolean isValidForLevel(@Nullable ChunkHolder holder, int level) {
        return holder != null && holder.func_219299_i() <= level;
    }

    @Shadow
    @Nullable
    protected abstract ChunkHolder func_217213_a(long var1);

    @Shadow
    protected abstract boolean func_217235_l();
}

