/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.repack.ltlib.codec;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public final class CodecRegistry<K, V>
implements Codec<V>,
Iterable<V> {
    private final Codec<K> keyCodec;
    private final BiMap<K, V> map = HashBiMap.create();

    private CodecRegistry(Codec<K> keyCodec) {
        this.keyCodec = keyCodec;
    }

    public static <V> CodecRegistry<String, V> stringKeys() {
        return new CodecRegistry(Codec.STRING);
    }

    public static <V> CodecRegistry<ResourceLocation, V> resourceLocationKeys() {
        return new CodecRegistry(ResourceLocation.field_240908_a_);
    }

    public void clear() {
        this.map.clear();
    }

    public void register(K key, V value) {
        this.map.put(key, value);
    }

    @Nullable
    public V get(K key) {
        return (V)this.map.get(key);
    }

    @Nullable
    public K getKey(V value) {
        return (K)this.map.inverse().get(value);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public <U> DataResult<Pair<V, U>> decode(DynamicOps<U> ops, U input) {
        return this.keyCodec.decode(ops, input).flatMap(pair -> {
            if (!this.containsKey(pair.getFirst())) {
                return DataResult.error((String)("Unknown registry key: " + pair.getFirst()));
            }
            return DataResult.success((Object)pair.mapFirst(this::get));
        });
    }

    public <U> DataResult<U> encode(V input, DynamicOps<U> ops, U prefix) {
        K key = this.getKey(input);
        if (key == null) {
            return DataResult.error((String)("Unknown registry element " + input));
        }
        return this.keyCodec.encodeStart(ops, key).flatMap(keyData -> ops.mergeToPrimitive(prefix, keyData));
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    @Nonnull
    public Iterator<V> iterator() {
        return this.map.values().iterator();
    }

    public Stream<V> stream() {
        return this.map.values().stream();
    }
}

