/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.repack.ltlib.codec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.BlockPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class MoreCodecs {
    public static final Codec<ItemStack> ITEM_STACK = Codec.either((Codec)ItemStack.field_234691_a_, (Codec)Registry.field_212630_s).xmap(either -> (ItemStack)either.map(Function.identity(), ItemStack::new), Either::left);
    public static final Codec<BlockState> BLOCK_STATE = Codec.either((Codec)BlockState.field_235877_b_, (Codec)Registry.field_212618_g).xmap(either -> (BlockState)either.map(Function.identity(), Block::func_176223_P), Either::left);
    public static final Codec<BlockStateProvider> BLOCK_STATE_PROVIDER = Codec.either((Codec)BlockStateProvider.field_236796_a_, BLOCK_STATE).xmap(either -> (BlockStateProvider)either.map(Function.identity(), SimpleBlockStateProvider::new), Either::left);
    public static final Codec<ITextComponent> TEXT = MoreCodecs.withJson(ITextComponent.Serializer::func_200528_b, json -> {
        IFormattableTextComponent text = ITextComponent.Serializer.func_240641_a_((JsonElement)json);
        return text != null ? DataResult.success((Object)text) : DataResult.error((String)"Malformed text");
    });
    public static final Codec<DyeColor> DYE_COLOR = MoreCodecs.stringVariants(DyeColor.values(), DyeColor::func_176610_l);
    public static final Codec<EquipmentSlotType> EQUIPMENT_SLOT = MoreCodecs.stringVariants(EquipmentSlotType.values(), EquipmentSlotType::func_188450_d);
    public static final Codec<TextFormatting> FORMATTING = MoreCodecs.stringVariants(TextFormatting.values(), TextFormatting::func_96297_d);
    public static final Codec<Color> COLOR = Codec.STRING.comapFlatMap(name -> {
        Color color = Color.func_240745_a_((String)name);
        return color != null ? DataResult.success((Object)color) : DataResult.error((String)"Invalid color format");
    }, Color::toString);
    public static final Codec<GameType> GAME_TYPE = MoreCodecs.stringVariants(GameType.values(), GameType::func_77149_b);
    public static final Codec<UUID> UUID_STRING = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)UUID.fromString(string));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error((String)"Malformed UUID!");
        }
    }, UUID::toString);
    public static final Codec<BlockPredicate> BLOCK_PREDICATE = MoreCodecs.withJson(BlockPredicate::func_226236_a_, json -> {
        try {
            return DataResult.success((Object)BlockPredicate.func_226237_a_((JsonElement)json));
        }
        catch (JsonSyntaxException e) {
            return DataResult.error((String)e.getMessage());
        }
    });
    public static final Codec<Vector3d> VECTOR_3D = Codec.DOUBLE.listOf().comapFlatMap(doubles -> {
        if (doubles.size() == 3) {
            return DataResult.success((Object)new Vector3d(((Double)doubles.get(0)).doubleValue(), ((Double)doubles.get(1)).doubleValue(), ((Double)doubles.get(2)).doubleValue()));
        }
        return DataResult.error((String)"Wrong number of vector components!");
    }, vector -> ImmutableList.of((Object)vector.field_72450_a, (Object)vector.field_72448_b, (Object)vector.field_72449_c));
    public static final Codec<Vector3f> VECTOR_3F = Codec.FLOAT.listOf().comapFlatMap(floats -> {
        if (floats.size() == 3) {
            return DataResult.success((Object)new Vector3f(((Float)floats.get(0)).floatValue(), ((Float)floats.get(1)).floatValue(), ((Float)floats.get(2)).floatValue()));
        }
        return DataResult.error((String)"Wrong number of vector components!");
    }, vector -> ImmutableList.of((Object)Float.valueOf(vector.func_195899_a()), (Object)Float.valueOf(vector.func_195900_b()), (Object)Float.valueOf(vector.func_195902_c())));
    public static final Codec<AxisAlignedBB> AABB = RecordCodecBuilder.create(instance -> instance.group((App)VECTOR_3D.fieldOf("start").forGetter(aabb -> new Vector3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c)), (App)VECTOR_3D.fieldOf("end").forGetter(aabb -> new Vector3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f))).apply((Applicative)instance, AxisAlignedBB::new));

    public static <T> Codec<T[]> arrayOrUnit(Codec<T> codec, IntFunction<T[]> factory) {
        return MoreCodecs.listToArray(MoreCodecs.listOrUnit(codec), factory);
    }

    public static <T> Codec<List<T>> listOrUnit(Codec<T> codec) {
        return Codec.either((Codec)codec.listOf(), codec).xmap(either -> (List)either.map(Function.identity(), MoreCodecs::unitArrayList), list -> list.size() == 1 ? Either.right(list.get(0)) : Either.left((Object)list));
    }

    public static <T> Codec<T[]> listToArray(Codec<List<T>> codec, IntFunction<T[]> factory) {
        return codec.xmap(list -> list.toArray((Object[])factory.apply(0)), Arrays::asList);
    }

    public static <A> Codec<A> stringVariants(A[] values, Function<A, String> asName) {
        return MoreCodecs.keyedVariants(values, asName, Codec.STRING);
    }

    public static <A, K> Codec<A> keyedVariants(A[] values, Function<A, K> asKey, Codec<K> keyCodec) {
        Object2ObjectOpenHashMap byKey = new Object2ObjectOpenHashMap();
        for (A value : values) {
            byKey.put(asKey.apply(value), value);
        }
        return keyCodec.comapFlatMap(arg_0 -> MoreCodecs.lambda$keyedVariants$17((Map)byKey, arg_0), asKey);
    }

    public static <A> Codec<A> withJson(Function<A, JsonElement> encode, Function<JsonElement, DataResult<A>> decode) {
        return MoreCodecs.withOps(JsonOps.INSTANCE, encode, decode);
    }

    public static <A> Codec<A> withNbt(Function<A, INBT> encode, Function<INBT, DataResult<A>> decode) {
        return MoreCodecs.withOps(NBTDynamicOps.field_210820_a, encode, decode);
    }

    public static <A> Codec<A> withNbtCompound(BiFunction<A, CompoundNBT, CompoundNBT> encode, BiConsumer<A, CompoundNBT> decode, Supplier<A> factory) {
        return MoreCodecs.withNbt(value -> (CompoundNBT)encode.apply(value, new CompoundNBT()), nbt -> {
            if (nbt instanceof CompoundNBT) {
                Object value = factory.get();
                decode.accept(value, (CompoundNBT)nbt);
                return DataResult.success(value);
            }
            return DataResult.error((String)"Expected compound tag");
        });
    }

    public static <A, T> Codec<A> withOps(DynamicOps<T> ops, Function<A, T> encode, Function<T, DataResult<A>> decode) {
        return new MappedOpsCodec<A, T>(ops, encode, decode);
    }

    public static <N extends Number> Codec<N> numberAsString(Function<String, N> parse) {
        return Codec.STRING.comapFlatMap(s -> {
            try {
                return DataResult.success(parse.apply((String)s));
            }
            catch (NumberFormatException e) {
                return DataResult.error((String)("Failed to parse number '" + s + "'"));
            }
        }, Object::toString);
    }

    public static <V> Codec<Long2ObjectMap<V>> long2Object(Codec<V> codec) {
        return Codec.unboundedMap(MoreCodecs.numberAsString(Long::parseLong), codec).xmap(Long2ObjectOpenHashMap::new, HashMap::new);
    }

    public static <K> Codec<Object2FloatMap<K>> object2Float(Codec<K> codec) {
        return Codec.unboundedMap(codec, (Codec)Codec.FLOAT).xmap(Object2FloatOpenHashMap::new, HashMap::new);
    }

    public static <K> Codec<Object2DoubleMap<K>> object2Double(Codec<K> codec) {
        return Codec.unboundedMap(codec, (Codec)Codec.DOUBLE).xmap(Object2DoubleOpenHashMap::new, HashMap::new);
    }

    public static <T> Codec<RegistryKey<T>> registryKey(RegistryKey<? extends Registry<T>> registry) {
        return ResourceLocation.field_240908_a_.xmap(id -> RegistryKey.func_240903_a_((RegistryKey)registry, (ResourceLocation)id), RegistryKey::func_240901_a_);
    }

    public static <T, C extends List<T>> Codec<C> sorted(Codec<C> codec, Comparator<? super T> comparator) {
        return codec.xmap(list -> {
            list.sort(comparator);
            return list;
        }, Function.identity());
    }

    public static <K, V> Codec<Map<K, V>> dispatchByMapKey(Codec<K> keyCodec, Function<K, Codec<V>> valueCodec) {
        return new DispatchMapCodec<K, V>(keyCodec, valueCodec);
    }

    public static <T extends IForgeRegistryEntry<T>> Codec<T> ofForgeRegistry(final Supplier<IForgeRegistry<T>> registry) {
        return new Codec<T>(){

            public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U input) {
                return ResourceLocation.field_240908_a_.decode(ops, input).flatMap(arg_0 -> 1.lambda$decode$0((Supplier)registry, arg_0));
            }

            public <U> DataResult<U> encode(T input, DynamicOps<U> ops, U prefix) {
                ResourceLocation key = ((IForgeRegistry)registry.get()).getKey(input);
                if (key == null) {
                    return DataResult.error((String)("Unknown registry element " + input));
                }
                return ops.mergeToPrimitive(prefix, ops.createString(key.toString()));
            }

            private static /* synthetic */ DataResult lambda$decode$0(Supplier registry2, Pair pair) {
                if (!((IForgeRegistry)registry2.get()).containsKey((ResourceLocation)pair.getFirst())) {
                    return DataResult.error((String)("Unknown registry key: " + pair.getFirst()));
                }
                return DataResult.success((Object)pair.mapFirst(arg_0 -> ((IForgeRegistry)((IForgeRegistry)registry2.get())).getValue(arg_0)));
            }
        };
    }

    public static <T> Codec<T> validate(Codec<T> codec, Function<T, DataResult<T>> validate) {
        return codec.flatXmap(validate, validate);
    }

    public static <T> Codec<T> validate(Codec<T> codec, Predicate<T> validate, String error) {
        return MoreCodecs.validate(codec, value -> {
            if (validate.test(value)) {
                return DataResult.success((Object)value);
            }
            return DataResult.error((String)error);
        });
    }

    public static Codec<LocalDateTime> localDateTime(DateTimeFormatter formatter) {
        return Codec.STRING.comapFlatMap(string -> {
            try {
                return DataResult.success((Object)LocalDateTime.parse(string, formatter));
            }
            catch (DateTimeParseException e) {
                return DataResult.error((String)("Failed to parse date: " + string));
            }
        }, formatter::format);
    }

    private static <T> List<T> unitArrayList(T t) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(t);
        return list;
    }

    private static /* synthetic */ DataResult lambda$keyedVariants$17(Map byKey, Object key) {
        Object value = byKey.get(key);
        return value != null ? DataResult.success(value) : DataResult.error((String)("No variant with key '" + key + "'"));
    }

    static final class DispatchMapCodec<K, V>
    implements Codec<Map<K, V>> {
        private final Codec<K> keyCodec;
        private final Function<K, Codec<V>> valueCodec;

        DispatchMapCodec(Codec<K> keyCodec, Function<K, Codec<V>> valueCodec) {
            this.keyCodec = keyCodec;
            this.valueCodec = valueCodec;
        }

        public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getMap(input).flatMap(mapInput -> {
                ImmutableMap.Builder read = ImmutableMap.builder();
                ImmutableList.Builder failed = ImmutableList.builder();
                DataResult result = mapInput.entries().reduce(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()), (r, pair) -> this.keyCodec.parse(ops, pair.getFirst()).flatMap(key -> {
                    DataResult entry = this.valueCodec.apply(key).parse(ops, pair.getSecond()).map(value -> Pair.of((Object)key, (Object)value));
                    entry.error().ifPresent(e -> failed.add(pair));
                    return r.apply2stable((u, p) -> {
                        read.put(p.getFirst(), p.getSecond());
                        return u;
                    }, entry);
                }), (r1, r2) -> r1.apply2stable((u1, u2) -> u1, r2));
                ImmutableMap elements = read.build();
                Object errors = ops.createMap(failed.build().stream());
                return result.map(arg_0 -> DispatchMapCodec.lambda$null$7((Map)elements, input, arg_0)).setPartial((Object)Pair.of((Object)elements, (Object)input)).mapError(e -> e + " missed input: " + errors);
            });
        }

        public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
            RecordBuilder map = ops.mapBuilder();
            for (Map.Entry<K, V> entry : input.entrySet()) {
                K key = entry.getKey();
                V value = entry.getValue();
                map.add(this.keyCodec.encodeStart(ops, key), this.valueCodec.apply(key).encodeStart(ops, value));
            }
            return map.build(prefix);
        }

        private static /* synthetic */ Pair lambda$null$7(Map elements, Object input, Unit unit) {
            return Pair.of((Object)elements, (Object)input);
        }
    }

    static final class MappedOpsCodec<A, S>
    implements Codec<A> {
        private final DynamicOps<S> sourceOps;
        private final Function<A, S> encode;
        private final Function<S, DataResult<A>> decode;

        MappedOpsCodec(DynamicOps<S> sourceOps, Function<A, S> encode, Function<S, DataResult<A>> decode) {
            this.sourceOps = sourceOps;
            this.encode = encode;
            this.decode = decode;
        }

        public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
            S sourceData = this.encode.apply(input);
            S targetData = ops == this.sourceOps ? sourceData : this.sourceOps.convertTo(ops, sourceData);
            return ops.getMap(targetData).flatMap(map -> ops.mergeToMap(prefix, map));
        }

        public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
            Object sourceData = ops == this.sourceOps ? input : ops.convertTo(this.sourceOps, input);
            return this.decode.apply(sourceData).map(output -> Pair.of((Object)output, (Object)input));
        }
    }
}

