/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.repack.registrate.providers;

import com.lovetropics.extras.repack.registrate.AbstractRegistrate;
import com.lovetropics.extras.repack.registrate.providers.ProviderType;
import com.lovetropics.extras.repack.registrate.providers.RegistrateProvider;
import com.lovetropics.extras.repack.registrate.util.nullness.NonNullSupplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.LogicalSide;

public class RegistrateItemModelProvider
extends ItemModelProvider
implements RegistrateProvider {
    private final AbstractRegistrate<?> parent;

    public RegistrateItemModelProvider(AbstractRegistrate<?> parent, DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, parent.getModid(), existingFileHelper);
        this.parent = parent;
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.CLIENT;
    }

    protected void registerModels() {
        this.parent.genData(ProviderType.ITEM_MODEL, this);
    }

    public String func_200397_b() {
        return "Item models";
    }

    public String modid(NonNullSupplier<? extends IItemProvider> item) {
        return item.get().func_199767_j().getRegistryName().func_110624_b();
    }

    public String name(NonNullSupplier<? extends IItemProvider> item) {
        return item.get().func_199767_j().getRegistryName().func_110623_a();
    }

    public ResourceLocation itemTexture(NonNullSupplier<? extends IItemProvider> item) {
        return this.modLoc("item/" + this.name(item));
    }

    public ItemModelBuilder blockItem(NonNullSupplier<? extends IItemProvider> block) {
        return this.blockItem(block, "");
    }

    public ItemModelBuilder blockItem(NonNullSupplier<? extends IItemProvider> block, String suffix) {
        return (ItemModelBuilder)this.withExistingParent(this.name(block), new ResourceLocation(this.modid(block), "block/" + this.name(block) + suffix));
    }

    public ItemModelBuilder blockWithInventoryModel(NonNullSupplier<? extends IItemProvider> block) {
        return (ItemModelBuilder)this.withExistingParent(this.name(block), new ResourceLocation(this.modid(block), "block/" + this.name(block) + "_inventory"));
    }

    public ItemModelBuilder blockSprite(NonNullSupplier<? extends IItemProvider> block) {
        return this.blockSprite(block, this.modLoc("block/" + this.name(block)));
    }

    public ItemModelBuilder blockSprite(NonNullSupplier<? extends IItemProvider> block, ResourceLocation texture) {
        return this.generated(() -> ((IItemProvider)block.get()).func_199767_j(), texture);
    }

    public ItemModelBuilder generated(NonNullSupplier<? extends IItemProvider> item) {
        return this.generated(item, this.itemTexture(item));
    }

    public ItemModelBuilder generated(NonNullSupplier<? extends IItemProvider> item, ResourceLocation ... layers) {
        ItemModelBuilder ret = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.name(item))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
        for (int i = 0; i < layers.length; ++i) {
            ret = (ItemModelBuilder)ret.texture("layer" + i, layers[i]);
        }
        return ret;
    }

    public ItemModelBuilder handheld(NonNullSupplier<? extends IItemProvider> item) {
        return this.handheld(item, this.itemTexture(item));
    }

    public ItemModelBuilder handheld(NonNullSupplier<? extends IItemProvider> item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.name(item), "item/handheld")).texture("layer0", texture);
    }
}

