/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.repack.registrate.providers.loot;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.lovetropics.extras.repack.registrate.AbstractRegistrate;
import com.lovetropics.extras.repack.registrate.providers.ProviderType;
import com.lovetropics.extras.repack.registrate.providers.RegistrateProvider;
import com.lovetropics.extras.repack.registrate.providers.loot.RegistrateBlockLootTables;
import com.lovetropics.extras.repack.registrate.providers.loot.RegistrateEntityLootTables;
import com.lovetropics.extras.repack.registrate.providers.loot.RegistrateLootTables;
import com.lovetropics.extras.repack.registrate.util.nullness.NonNullBiFunction;
import com.lovetropics.extras.repack.registrate.util.nullness.NonNullConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class RegistrateLootTableProvider
extends LootTableProvider
implements RegistrateProvider {
    private static final Map<String, LootType<?>> LOOT_TYPES = new HashMap();
    private final AbstractRegistrate<?> parent;
    private final Multimap<LootType<?>, Consumer<? super RegistrateLootTables>> specialLootActions = HashMultimap.create();
    private final Multimap<LootParameterSet, Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>> lootActions = HashMultimap.create();
    private final Set<RegistrateLootTables> currentLootCreators = new HashSet<RegistrateLootTables>();
    private static final BiMap<ResourceLocation, LootParameterSet> SET_REGISTRY = (BiMap)ObfuscationReflectionHelper.getPrivateValue(LootParameterSets.class, null, (String)"field_216268_i");

    public RegistrateLootTableProvider(AbstractRegistrate<?> parent, DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.parent = parent;
    }

    public String func_200397_b() {
        return "Loot tables";
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.SERVER;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationresults) {
        this.currentLootCreators.forEach(c -> c.validate(map, validationresults));
    }

    public <T extends RegistrateLootTables> void addLootAction(LootType<T> type, NonNullConsumer<T> action) {
        this.specialLootActions.put(type, action);
    }

    public void addLootAction(LootParameterSet set, Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> action) {
        this.lootActions.put((Object)set, action);
    }

    private Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>> getLootCreator(AbstractRegistrate<?> parent, LootType<?> type) {
        return () -> {
            RegistrateLootTables creator = type.getLootCreator(parent, (T cons) -> this.specialLootActions.get((Object)type).forEach(c -> c.accept(cons)));
            this.currentLootCreators.add(creator);
            return creator;
        };
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        this.parent.genData(ProviderType.LOOT, this);
        this.currentLootCreators.clear();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (LootType<?> type : LOOT_TYPES.values()) {
            builder.add((Object)Pair.of(this.getLootCreator(this.parent, type), (Object)type.getLootSet()));
        }
        for (LootParameterSet set : SET_REGISTRY.values()) {
            builder.add((Object)Pair.of(() -> callback -> this.lootActions.get((Object)set).forEach(a -> a.accept(callback)), (Object)set));
        }
        return builder.build();
    }

    public static interface LootType<T extends RegistrateLootTables> {
        public static final LootType<RegistrateBlockLootTables> BLOCK = LootType.register("block", LootParameterSets.field_216267_h, RegistrateBlockLootTables::new);
        public static final LootType<RegistrateEntityLootTables> ENTITY = LootType.register("entity", LootParameterSets.field_216263_d, RegistrateEntityLootTables::new);

        public T getLootCreator(AbstractRegistrate<?> var1, Consumer<T> var2);

        public LootParameterSet getLootSet();

        public static <T extends RegistrateLootTables> LootType<T> register(String name, final LootParameterSet set, final NonNullBiFunction<AbstractRegistrate, Consumer<T>, T> factory) {
            LootType type = new LootType<T>(){

                @Override
                public T getLootCreator(AbstractRegistrate<?> parent, Consumer<T> callback) {
                    return (RegistrateLootTables)factory.apply(parent, callback);
                }

                @Override
                public LootParameterSet getLootSet() {
                    return set;
                }
            };
            LOOT_TYPES.put(name, type);
            return type;
        }
    }
}

