/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.client;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.therandomlabs.randompatches.RandomPatches;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="randompatches")
public final class RPContributorCapeHandler {
    private static final URI CONTRIBUTORS = URI.create("https://raw.githubusercontent.com/TheRandomLabs/RandomPatches/misc/contributors.txt");
    private static final ResourceLocation CAPE = new ResourceLocation("randompatches", "textures/contributor_cape.png");
    private static final Set<UUID> temporaryPlayerInfos = new HashSet<UUID>();
    private static final List<String> contributors = new ArrayList<String>();
    private static boolean attemptingDownload;
    private static int tries;

    private RPContributorCapeHandler() {
    }

    @SubscribeEvent
    public static void onPreRenderPlayer(RenderPlayerEvent.Pre event) {
        if (!RandomPatches.config().client.contributorCapes) {
            return;
        }
        if (contributors.isEmpty()) {
            RPContributorCapeHandler.downloadContributorList();
            return;
        }
        AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)event.getPlayer();
        if (FMLEnvironment.production && !contributors.contains(player.func_189512_bd())) {
            return;
        }
        if (player.func_175155_b() == null) {
            SPlayerListItemPacket sPlayerListItemPacket = new SPlayerListItemPacket();
            sPlayerListItemPacket.getClass();
            player.field_175157_a = new NetworkPlayerInfo(new SPlayerListItemPacket.AddPlayerData(sPlayerListItemPacket, player.func_146103_bH(), 0, null, null));
            temporaryPlayerInfos.add(player.func_110124_au());
        }
        player.field_175157_a.field_187107_a.putIfAbsent(MinecraftProfileTexture.Type.CAPE, CAPE);
        player.field_175157_a.field_187107_a.putIfAbsent(MinecraftProfileTexture.Type.ELYTRA, CAPE);
    }

    @SubscribeEvent
    public static void onPostRenderPlayer(RenderPlayerEvent.Post event) {
        AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)event.getPlayer();
        UUID uniqueID = player.func_110124_au();
        if (temporaryPlayerInfos.contains(uniqueID)) {
            player.field_175157_a = null;
            temporaryPlayerInfos.remove(uniqueID);
        }
    }

    public static void downloadContributorList() {
        if (attemptingDownload || tries > 5) {
            return;
        }
        attemptingDownload = true;
        new Thread(() -> {
            try {
                contributors.clear();
                contributors.addAll(IOUtils.readLines((Reader)new StringReader(IOUtils.toString((URI)CONTRIBUTORS, (Charset)StandardCharsets.UTF_8))));
            }
            catch (IOException ex) {
                RandomPatches.logger.error("Failed to download contributor list", (Throwable)ex);
                ++tries;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex2) {
                    RandomPatches.logger.error("Failed to sleep", (Throwable)ex2);
                }
            }
            attemptingDownload = false;
        }).start();
    }
}

