/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.tutorials.repack.ltlib;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;

public final class BlockBox
implements Iterable<BlockPos> {
    public static final Codec<BlockBox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.field_239578_a_.fieldOf("min").forGetter(c -> c.min), (App)BlockPos.field_239578_a_.fieldOf("max").forGetter(c -> c.max)).apply((Applicative)instance, BlockBox::of));
    public final BlockPos min;
    public final BlockPos max;

    private BlockBox(BlockPos min, BlockPos max) {
        this.min = min;
        this.max = max;
    }

    public static BlockBox of(BlockPos pos) {
        return new BlockBox(pos, pos);
    }

    public static BlockBox of(BlockPos a, BlockPos b) {
        return new BlockBox(BlockBox.min(a, b), BlockBox.max(a, b));
    }

    public static BlockBox ofChunk(int chunkX, int chunkZ) {
        return new BlockBox(new BlockPos(chunkX << 4, 0, chunkZ << 4), new BlockPos((chunkX << 4) + 15, 256, (chunkZ << 16) + 15));
    }

    public static BlockBox ofChunk(ChunkPos chunkPos) {
        return BlockBox.ofChunk(chunkPos.field_77276_a, chunkPos.field_77275_b);
    }

    public static BlockPos min(BlockPos a, BlockPos b) {
        return new BlockPos(Math.min(a.func_177958_n(), b.func_177958_n()), Math.min(a.func_177956_o(), b.func_177956_o()), Math.min(a.func_177952_p(), b.func_177952_p()));
    }

    public static BlockPos max(BlockPos a, BlockPos b) {
        return new BlockPos(Math.max(a.func_177958_n(), b.func_177958_n()), Math.max(a.func_177956_o(), b.func_177956_o()), Math.max(a.func_177952_p(), b.func_177952_p()));
    }

    public BlockBox withMin(BlockPos min) {
        return BlockBox.of(min, this.max);
    }

    public BlockBox withMax(BlockPos max) {
        return BlockBox.of(this.min, max);
    }

    public BlockBox offset(double x, double y, double z) {
        return new BlockBox(this.min.func_177963_a(x, y, z), this.max.func_177963_a(x, y, z));
    }

    public Vector3d getCenter() {
        return new Vector3d(((double)(this.min.func_177958_n() + this.max.func_177958_n()) + 1.0) / 2.0, ((double)(this.min.func_177956_o() + this.max.func_177956_o()) + 1.0) / 2.0, ((double)(this.min.func_177952_p() + this.max.func_177952_p()) + 1.0) / 2.0);
    }

    public BlockPos getCenterBlock() {
        return new BlockPos((this.min.func_177958_n() + this.max.func_177958_n() + 1) / 2, (this.min.func_177956_o() + this.max.func_177956_o() + 1) / 2, (this.min.func_177952_p() + this.max.func_177952_p() + 1) / 2);
    }

    public BlockPos getSize() {
        return new BlockPos(this.max.func_177958_n() - this.min.func_177958_n() + 1, this.max.func_177956_o() - this.min.func_177956_o() + 1, this.max.func_177952_p() - this.min.func_177952_p() + 1);
    }

    public long getVolume() {
        long sizeX = this.max.func_177958_n() - this.min.func_177958_n() + 1;
        long sizeY = this.max.func_177956_o() - this.min.func_177956_o() + 1;
        long sizeZ = this.max.func_177952_p() - this.min.func_177952_p() + 1;
        return sizeX * sizeY * sizeZ;
    }

    public BlockPos sample(Random random) {
        return new BlockPos(this.min.func_177958_n() + random.nextInt(this.max.func_177958_n() - this.min.func_177958_n() + 1), this.min.func_177956_o() + random.nextInt(this.max.func_177956_o() - this.min.func_177956_o() + 1), this.min.func_177952_p() + random.nextInt(this.max.func_177952_p() - this.min.func_177952_p() + 1));
    }

    public boolean contains(BlockPos pos) {
        return this.contains(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean contains(Vector3d pos) {
        return this.contains(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public boolean contains(double x, double y, double z) {
        BlockPos min = this.min;
        BlockPos max = this.max;
        return x >= (double)min.func_177958_n() && y >= (double)min.func_177956_o() && z >= (double)min.func_177952_p() && x <= (double)max.func_177958_n() && y <= (double)max.func_177956_o() && z <= (double)max.func_177952_p();
    }

    public boolean contains(int x, int y, int z) {
        BlockPos min = this.min;
        BlockPos max = this.max;
        return x >= min.func_177958_n() && y >= min.func_177956_o() && z >= min.func_177952_p() && x <= max.func_177958_n() && y <= max.func_177956_o() && z <= max.func_177952_p();
    }

    public boolean intersects(AxisAlignedBB aabb) {
        return aabb.func_186668_a((double)this.min.func_177958_n(), (double)this.min.func_177956_o(), (double)this.min.func_177952_p(), (double)this.max.func_177958_n() + 1.0, (double)this.max.func_177956_o() + 1.0, (double)this.max.func_177952_p() + 1.0);
    }

    public boolean intersects(BlockBox other) {
        return this.max.func_177958_n() >= other.min.func_177958_n() && this.min.func_177958_n() <= other.max.func_177958_n() && this.max.func_177956_o() >= other.min.func_177956_o() && this.min.func_177956_o() <= other.max.func_177956_o() && this.max.func_177952_p() >= other.min.func_177952_p() && this.min.func_177952_p() <= other.max.func_177952_p();
    }

    @Nullable
    public BlockBox intersection(BlockBox other) {
        BlockPos min = BlockBox.max(this.min, other.min);
        BlockPos max = BlockBox.min(this.max, other.max);
        if (min.func_177958_n() >= max.func_177958_n() || min.func_177956_o() >= max.func_177956_o() || min.func_177952_p() >= max.func_177952_p()) {
            return null;
        }
        return new BlockBox(min, max);
    }

    public AxisAlignedBB asAabb() {
        return new AxisAlignedBB((double)this.min.func_177958_n(), (double)this.min.func_177956_o(), (double)this.min.func_177952_p(), (double)this.max.func_177958_n() + 1.0, (double)this.max.func_177956_o() + 1.0, (double)this.max.func_177952_p() + 1.0);
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return BlockPos.func_218278_a((BlockPos)this.min, (BlockPos)this.max).iterator();
    }

    public LongSet asChunks() {
        LongOpenHashSet chunks = new LongOpenHashSet();
        int minChunkX = this.min.func_177958_n() >> 4;
        int minChunkZ = this.min.func_177952_p() >> 4;
        int maxChunkX = this.max.func_177958_n() >> 4;
        int maxChunkZ = this.max.func_177952_p() >> 4;
        for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                chunks.add(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ));
            }
        }
        return chunks;
    }

    public CompoundNBT write(CompoundNBT root) {
        root.func_218657_a("min", (INBT)BlockBox.writeBlockPos(this.min, new CompoundNBT()));
        root.func_218657_a("max", (INBT)BlockBox.writeBlockPos(this.max, new CompoundNBT()));
        return root;
    }

    public static BlockBox read(CompoundNBT root) {
        BlockPos min = BlockBox.readBlockPos(root.func_74775_l("min"));
        BlockPos max = BlockBox.readBlockPos(root.func_74775_l("max"));
        return new BlockBox(min, max);
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179255_a(this.min);
        buffer.func_179255_a(this.max);
    }

    public static BlockBox read(PacketBuffer buffer) {
        BlockPos min = buffer.func_179259_c();
        BlockPos max = buffer.func_179259_c();
        return new BlockBox(min, max);
    }

    private static CompoundNBT writeBlockPos(BlockPos pos, CompoundNBT root) {
        root.func_74768_a("x", pos.func_177958_n());
        root.func_74768_a("y", pos.func_177956_o());
        root.func_74768_a("z", pos.func_177952_p());
        return root;
    }

    private static BlockPos readBlockPos(CompoundNBT root) {
        return new BlockPos(root.func_74762_e("x"), root.func_74762_e("y"), root.func_74762_e("z"));
    }
}

