/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.tutorials.repack.ltlib.entity;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public final class FireworkPalette {
    private static final Random RANDOM = new Random();
    static final int CE_YELLOW = 16041012;
    static final int CE_BLUE = 6666715;
    static final int CE_GREEN = 11653785;
    static final int CE_RED = 15356243;
    static final int CE_ORANGE = 15763271;
    static final int CE_PURPLE = 8478886;
    static final int CE_NAVY = 3752019;
    public static final FireworkPalette DYE_COLORS = new FireworkPalette(new int[0][]);
    public static final FireworkPalette PUERTO_RICO = new FireworkPalette(new int[][]{{11743532, 0xF0F0F0, 2437522, 6998340, 16105792, 1021572}});
    public static final FireworkPalette COOL_EARTH = new FireworkPalette({16041012, 6666715, 11653785}, {15356243, 15763271, 8478886}, {16041012, 6666715, 8478886}, {6666715, 11653785, 3752019});
    public static final FireworkPalette ISLAND_ROYALE = new FireworkPalette(new int[][]{{0}});
    private final int[][] palette;

    private FireworkPalette(int[] ... palette) {
        this.palette = palette;
    }

    public int[][] getPalette() {
        return this.palette;
    }

    @Nonnull
    public FireworkRocketEntity create(@Nonnull World world) {
        return this.create(world, new BlockPos(0, 0, 0));
    }

    @Nonnull
    public FireworkRocketEntity create(@Nonnull World world, @Nonnull BlockPos pos) {
        int[] colors;
        ItemStack firework = new ItemStack((IItemProvider)Items.field_196152_dE);
        firework.func_77982_d(new CompoundNBT());
        CompoundNBT explosion = new CompoundNBT();
        explosion.func_74757_a("Flicker", true);
        explosion.func_74757_a("Trail", true);
        if (this.palette.length == 0) {
            colors = new int[RANDOM.nextInt(8) + 1];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = DyeColor.values()[RANDOM.nextInt(16)].getColorValue();
            }
        } else {
            int[] palette = this.palette[RANDOM.nextInt(this.palette.length)];
            colors = new int[palette.length];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = palette[RANDOM.nextInt(palette.length)];
            }
        }
        explosion.func_74783_a("Colors", colors);
        byte type = (byte)(RANDOM.nextInt(3) + 1);
        type = type == 3 ? (byte)4 : (byte)type;
        explosion.func_74774_a("Type", type);
        ListNBT explosions = new ListNBT();
        explosions.add((Object)explosion);
        CompoundNBT fireworkTag = new CompoundNBT();
        fireworkTag.func_218657_a("Explosions", (INBT)explosions);
        fireworkTag.func_74774_a("Flight", (byte)1);
        firework.func_77983_a("Fireworks", (INBT)fireworkTag);
        return new FireworkRocketEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, firework);
    }

    public void spawn(@Nonnull BlockPos block, World world) {
        this.spawn(block, world, 0);
    }

    public void spawn(@Nonnull BlockPos pos, World world, int range) {
        BlockPos spawnPos = pos;
        if (range > 0) {
            spawnPos = new BlockPos(FireworkPalette.moveRandomly(spawnPos.func_177958_n(), range), (double)spawnPos.func_177956_o(), FireworkPalette.moveRandomly(spawnPos.func_177952_p(), range));
            BlockState bs = world.func_180495_p(spawnPos);
            int tries = -1;
            while (!world.func_175623_d(new BlockPos((Vector3i)spawnPos)) && !bs.func_185904_a().func_76230_c()) {
                if (++tries <= 100) continue;
                return;
            }
        }
        world.func_217376_c((Entity)this.create(world, spawnPos));
    }

    private static double moveRandomly(double base, double range) {
        return base + 0.5 + RANDOM.nextDouble() * range - range / 2.0;
    }
}

