/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lovetropics.tutorials.TutorialConfig;
import org.lovetropics.tutorials.network.SendTutorialsMessage;
import org.lovetropics.tutorials.network.TutorialsNetwork;

@Mod.EventBusSubscriber(modid="lttutorials")
public final class ServerTutorials {
    private static final Logger LOGGER = LogManager.getLogger(ServerTutorials.class);
    private static final JsonParser PARSER = new JsonParser();
    private static List<TutorialConfig> tutorials = new ArrayList<TutorialConfig>();
    private static boolean changed;

    @SubscribeEvent
    public static void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> {
            CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                ArrayList tutorials = new ArrayList();
                Collection paths = resourceManager.func_199003_a("tutorials", file -> file.endsWith(".json"));
                for (ResourceLocation path : paths) {
                    try {
                        IResource resource = resourceManager.func_199002_a(path);
                        Throwable throwable = null;
                        try {
                            DataResult<TutorialConfig> result = ServerTutorials.loadTutorial(resource);
                            result.result().ifPresent(tutorials::add);
                            result.error().ifPresent(error -> LOGGER.error("Failed to load tutorial config at {}: {}", (Object)path, error));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (resource == null) continue;
                            if (throwable != null) {
                                try {
                                    resource.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            resource.close();
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.error("Failed to load tutorial config at {}", (Object)path, (Object)e);
                    }
                }
                return tutorials;
            }, backgroundExecutor);
            return ((CompletableFuture)future.thenAcceptAsync(ServerTutorials::setTutorials, gameExecutor)).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0));
        });
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            ServerTutorials.sendTutorialsTo((ServerPlayerEntity)player, tutorials);
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        if (!changed) {
            return;
        }
        if (event.phase == TickEvent.Phase.START && event.world.func_234923_W_() == World.field_234918_g_) {
            MinecraftServer server = event.world.func_73046_m();
            for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
                ServerTutorials.sendTutorialsTo(player, tutorials);
            }
            changed = false;
        }
    }

    private static void setTutorials(List<TutorialConfig> tutorials) {
        ServerTutorials.tutorials = tutorials;
        changed = true;
    }

    private static void sendTutorialsTo(ServerPlayerEntity player, List<TutorialConfig> tutorials) {
        TutorialsNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SendTutorialsMessage(tutorials));
    }

    private static DataResult<TutorialConfig> loadTutorial(IResource resource) throws IOException {
        try (InputStream input = resource.func_199027_b();){
            JsonElement json = PARSER.parse((Reader)new BufferedReader(new InputStreamReader(input)));
            DataResult dataResult = TutorialConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            return dataResult;
        }
    }
}

