/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.World;
import org.lovetropics.tutorials.TutorialConfig;

public final class TutorialIndex {
    private final Map<RegistryKey<World>, Dimension> dimensions = new Reference2ObjectOpenHashMap();

    public void put(TutorialConfig tutorial) {
        tutorial.getSpace().addToIndex((dimension, chunk) -> this.put((RegistryKey<World>)dimension, chunk, tutorial));
    }

    public void put(RegistryKey<World> dimension, long chunk, TutorialConfig tutorial) {
        Dimension dimensionIndex = this.dimensions.computeIfAbsent(dimension, k -> new Dimension());
        List tutorialsInChunk = (List)dimensionIndex.chunkToTutorial.computeIfAbsent(chunk, c -> new ArrayList());
        tutorialsInChunk.add(tutorial);
    }

    public Iterable<TutorialConfig> get(RegistryKey<World> dimension, BlockPos pos) {
        Dimension dimensionIndex = this.dimensions.get(dimension);
        if (dimensionIndex == null) {
            return Collections.emptyList();
        }
        List tutorialsInChunk = (List)dimensionIndex.chunkToTutorial.get(SectionPos.func_218162_e((long)pos.func_218275_a()));
        if (tutorialsInChunk != null) {
            return Iterables.filter((Iterable)tutorialsInChunk, tutorial -> tutorial.getSpace().contains(dimension, pos));
        }
        return Collections.emptyList();
    }

    static final class Dimension {
        final Long2ObjectMap<List<TutorialConfig>> chunkToTutorial = new Long2ObjectOpenHashMap();

        Dimension() {
        }
    }
}

