/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials;

import com.lovetropics.tutorials.repack.ltlib.BlockBox;
import com.lovetropics.tutorials.repack.ltlib.codec.CodecRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.World;

public interface TutorialSpace {
    public static final CodecRegistry<String, Codec<? extends TutorialSpace>> REGISTRY = CodecRegistry.stringKeys();
    public static final Codec<TutorialSpace> CODEC = REGISTRY.dispatchStable(TutorialSpace::getCodec, Function.identity());

    public static void register() {
        REGISTRY.register("box", Box.CODEC);
    }

    public void addToIndex(Indexer var1);

    public boolean contains(RegistryKey<World> var1, BlockPos var2);

    public Codec<? extends TutorialSpace> getCodec();

    public static final class Box
    implements TutorialSpace {
        public static final Codec<Box> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)World.field_234917_f_.fieldOf("dimension").forGetter(c -> c.dimension), (App)BlockBox.CODEC.fieldOf("box").forGetter(c -> c.box)).apply((Applicative)instance, Box::new));
        private final RegistryKey<World> dimension;
        private final BlockBox box;

        public Box(RegistryKey<World> dimension, BlockBox box) {
            this.dimension = dimension;
            this.box = box;
        }

        @Override
        public void addToIndex(Indexer indexer) {
            SectionPos minSection = SectionPos.func_218167_a((BlockPos)this.box.min);
            SectionPos maxSection = SectionPos.func_218167_a((BlockPos)this.box.max);
            for (int z = minSection.func_218148_c(); z <= maxSection.func_218148_c(); ++z) {
                for (int y = minSection.func_218163_b(); y <= maxSection.func_218163_b(); ++y) {
                    for (int x = minSection.func_218149_a(); x <= maxSection.func_218149_a(); ++x) {
                        indexer.accept(this.dimension, SectionPos.func_218166_b((int)x, (int)y, (int)z));
                    }
                }
            }
        }

        @Override
        public boolean contains(RegistryKey<World> dimension, BlockPos pos) {
            return this.dimension == dimension && this.box.contains(pos);
        }

        @Override
        public Codec<? extends TutorialSpace> getCodec() {
            return CODEC;
        }
    }

    public static interface Indexer {
        public void accept(RegistryKey<World> var1, long var2);
    }
}

