/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.client;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lovetropics.tutorials.TutorialConfig;
import org.lovetropics.tutorials.TutorialIndex;

public final class TutorialClientState {
    private static TutorialClientState instance;
    private final List<TutorialConfig> tutorials;
    private final TutorialIndex index;

    private TutorialClientState(List<TutorialConfig> tutorials, TutorialIndex index) {
        this.tutorials = tutorials;
        this.index = index;
    }

    public static void set(List<TutorialConfig> tutorials) {
        TutorialIndex index = new TutorialIndex();
        for (TutorialConfig tutorial : tutorials) {
            index.put(tutorial);
        }
        instance = new TutorialClientState(tutorials, index);
    }

    @Nullable
    public static TutorialClientState get() {
        return instance;
    }

    public Iterable<TutorialConfig> getTutorialsAt(RegistryKey<World> dimension, BlockPos pos) {
        return this.index.get(dimension, pos);
    }
}

