/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lovetropics.tutorials.TutorialConfig;
import org.lovetropics.tutorials.client.TutorialClientState;
import org.lovetropics.tutorials.client.widget.TutorialWidgetRenderer;
import org.lovetropics.tutorials.client.widget.TutorialWidgetRenderers;
import org.lovetropics.tutorials.widget.TutorialWidget;

@Mod.EventBusSubscriber(modid="lttutorials", value={Dist.CLIENT})
public final class TutorialRenderManager {
    private static final Minecraft CLIENT = Minecraft.func_71410_x();
    private static DisplayState displayState;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ClientPlayerEntity player = TutorialRenderManager.CLIENT.field_71439_g;
        if (event.phase == TickEvent.Phase.END || player == null) {
            return;
        }
        DisplayState displayState = TutorialRenderManager.getDisplayState();
        if (displayState != null) {
            Entity camera = CLIENT.func_175606_aa();
            if (camera == null) {
                camera = player;
            }
            displayState.tick(camera);
        }
    }

    @Nullable
    private static DisplayState getDisplayState() {
        TutorialClientState clientState = TutorialClientState.get();
        DisplayState displayState = TutorialRenderManager.displayState;
        if (clientState != null && displayState == null || displayState != null && displayState.clientState != clientState) {
            TutorialRenderManager.displayState = displayState = new DisplayState(clientState);
        } else if (clientState == null && displayState != null) {
            TutorialRenderManager.displayState = null;
        }
        return displayState;
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        DisplayState displayState = TutorialRenderManager.displayState;
        if (displayState == null) {
            return;
        }
        ActiveRenderInfo camera = TutorialRenderManager.CLIENT.field_71460_t.func_215316_n();
        if (!camera.func_216786_h()) {
            return;
        }
        for (Reference2IntMap.Entry entry : Reference2IntMaps.fastIterable((Reference2IntMap)displayState.visible)) {
            TutorialConfig tutorial = (TutorialConfig)entry.getKey();
            List<TutorialWidget> widgets = tutorial.getWidgets();
            float animation = (float)entry.getIntValue() / 10.0f;
            for (TutorialWidget widget : widgets) {
                TutorialRenderManager.renderWidget(widget, event.getContext(), event.getMatrixStack(), camera, event.getPartialTicks(), animation);
            }
        }
    }

    public static <T extends TutorialWidget> void renderWidget(T widget, WorldRenderer context, MatrixStack matrixStack, ActiveRenderInfo camera, float partialTicks, float animation) {
        if (animation <= 0.01f) {
            return;
        }
        TutorialWidgetRenderer<T> renderer = TutorialWidgetRenderers.rendererFor(widget);
        if (renderer != null) {
            renderer.render(widget, context, matrixStack, camera, partialTicks, animation);
        }
    }

    public static <T extends TutorialWidget> void tickWidget(T widget, Entity camera) {
        TutorialWidgetRenderer<T> renderer = TutorialWidgetRenderers.rendererFor(widget);
        if (renderer != null) {
            renderer.tick(widget, camera);
        }
    }

    static final class DisplayState {
        private static final int ANIMATION_TICKS = 10;
        private final TutorialClientState clientState;
        private final Set<TutorialConfig> active = new ReferenceOpenHashSet();
        private final Reference2IntMap<TutorialConfig> visible = new Reference2IntOpenHashMap();
        private BlockPos lastPlayerPos;

        DisplayState(TutorialClientState clientState) {
            this.clientState = clientState;
        }

        void tick(Entity camera) {
            Set<TutorialConfig> active = this.active;
            Reference2IntMap<TutorialConfig> visible = this.visible;
            RegistryKey dimension = camera.field_70170_p.func_234923_W_();
            BlockPos pos = camera.func_233580_cy_();
            if (!pos.equals((Object)this.lastPlayerPos)) {
                this.lastPlayerPos = pos;
                active.clear();
                for (TutorialConfig tutorial : this.clientState.getTutorialsAt((RegistryKey<World>)dimension, pos)) {
                    active.add(tutorial);
                    visible.putIfAbsent((Object)tutorial, 0);
                }
            }
            this.tickVisibleTutorials(camera, visible);
        }

        private void tickVisibleTutorials(Entity camera, Reference2IntMap<TutorialConfig> visible) {
            ObjectIterator iterator = Reference2IntMaps.fastIterator(visible);
            while (iterator.hasNext()) {
                Reference2IntMap.Entry entry = (Reference2IntMap.Entry)iterator.next();
                TutorialConfig tutorial = (TutorialConfig)entry.getKey();
                int ticks = this.tickTutorial(camera, entry.getIntValue(), tutorial);
                entry.setValue(ticks);
                if (ticks > 0) continue;
                iterator.remove();
            }
        }

        private int tickTutorial(Entity camera, int ticks, TutorialConfig tutorial) {
            List<TutorialWidget> widgets = tutorial.getWidgets();
            for (TutorialWidget widget : widgets) {
                TutorialRenderManager.tickWidget(widget, camera);
            }
            if (this.active.contains(tutorial)) {
                return ticks < 10 ? ticks + 1 : ticks;
            }
            return ticks - 1;
        }
    }
}

