/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.client.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import org.lovetropics.tutorials.client.widget.TutorialWidgetRenderer;
import org.lovetropics.tutorials.util.Easings;
import org.lovetropics.tutorials.widget.ImageDisplayWidget;

public final class ImageDisplayRenderer
implements TutorialWidgetRenderer<ImageDisplayWidget> {
    @Override
    public void render(ImageDisplayWidget widget, WorldRenderer context, MatrixStack matrixStack, ActiveRenderInfo camera, float partialTicks, float animation) {
        Vector3d view = camera.func_216785_c();
        Vector3d pos = widget.getPos();
        ImageDisplayWidget.Texture texture = widget.getTexture();
        float scale = widget.getScale();
        Matrix4f pointAlong = widget.getPointAlongMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        RenderSystem.translatef((float)((float)(pos.field_72450_a - view.field_72450_a)), (float)((float)(pos.field_72448_b - view.field_72448_b)), (float)((float)(pos.field_72449_c - view.field_72449_c)));
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.multMatrix((Matrix4f)(pointAlong != null ? pointAlong : new Matrix4f(camera.func_227995_f_())));
        RenderSystem.scalef((float)(-scale), (float)(-scale), (float)scale);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.enableTexture();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float alpha = Easings.inOutSine(animation);
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228660_m_((ResourceLocation)texture.getPath()));
        float textureWidth = texture.getWidth();
        float textureHeight = texture.getHeight();
        float aspectRatio = textureWidth / textureHeight;
        float width = textureWidth > textureHeight ? 0.5f : 0.5f * aspectRatio;
        float height = textureHeight > textureWidth ? 0.5f : 0.5f * aspectRatio;
        builder.func_225582_a_((double)(-width), (double)(-height), 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(texture.getMinU(), texture.getMinV()).func_225587_b_(240, 240).func_181675_d();
        builder.func_225582_a_((double)width, (double)(-height), 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(texture.getMaxU(), texture.getMinV()).func_225587_b_(240, 240).func_181675_d();
        builder.func_225582_a_((double)width, (double)height, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(texture.getMaxU(), texture.getMaxV()).func_225587_b_(240, 240).func_181675_d();
        builder.func_225582_a_((double)(-width), (double)height, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(texture.getMinU(), texture.getMaxV()).func_225587_b_(240, 240).func_181675_d();
        buffer.func_228461_a_();
        RenderSystem.enableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.popMatrix();
    }
}

