/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.client.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.lovetropics.tutorials.client.widget.TutorialWidgetRenderer;
import org.lovetropics.tutorials.util.Easings;
import org.lovetropics.tutorials.widget.TextDisplayWidget;

public final class TextDisplayRenderer
implements TutorialWidgetRenderer<TextDisplayWidget> {
    private static final Minecraft CLIENT = Minecraft.func_71410_x();

    @Override
    public void render(TextDisplayWidget widget, WorldRenderer context, MatrixStack matrixStack, ActiveRenderInfo camera, float partialTicks, float animation) {
        Vector3d view = camera.func_216785_c();
        Vector3d pos = widget.getPos();
        ITextComponent text = widget.getText();
        float scale = widget.getScale();
        Matrix4f pointAlong = widget.getPointAlongMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        RenderSystem.translatef((float)((float)(pos.field_72450_a - view.field_72450_a)), (float)((float)(pos.field_72448_b + 0.07 - view.field_72448_b)), (float)((float)(pos.field_72449_c - view.field_72449_c)));
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.multMatrix((Matrix4f)(pointAlong != null ? pointAlong : new Matrix4f(camera.func_227995_f_())));
        RenderSystem.scalef((float)(-scale), (float)(-scale), (float)scale);
        RenderSystem.disableLighting();
        RenderSystem.disableCull();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float alpha = Easings.inOutSine(animation);
        if (alpha >= 0.1f) {
            FontRenderer font = TextDisplayRenderer.CLIENT.field_71466_p;
            Matrix4f identity = TransformationMatrix.func_227983_a_().func_227988_c_();
            int textColor = TextDisplayRenderer.alphaToColor(alpha) | 0xFFFFFF;
            int backgroundColor = TextDisplayRenderer.alphaToColor(TextDisplayRenderer.CLIENT.field_71474_y.func_216840_a(0.25f) * alpha);
            IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            font.func_243247_a(text, (float)(-font.func_238414_a_((ITextProperties)text)) / 2.0f, 0.0f, textColor, false, identity, (IRenderTypeBuffer)buffer, false, backgroundColor, 0xF000F0);
            buffer.func_228461_a_();
        }
        RenderSystem.enableCull();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    private static int alphaToColor(float alpha) {
        return MathHelper.func_76141_d((float)(alpha * 255.0f)) << 24;
    }
}

