/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.network;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.lovetropics.tutorials.TutorialConfig;
import org.lovetropics.tutorials.client.TutorialClientState;

public class SendTutorialsMessage {
    private final List<TutorialConfig> tutorials;

    public SendTutorialsMessage(List<TutorialConfig> tutorials) {
        this.tutorials = tutorials;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.tutorials.size());
        for (TutorialConfig tutorial : this.tutorials) {
            TutorialConfig.CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)tutorial).result().ifPresent(nbt -> buffer.func_150786_a((CompoundNBT)nbt));
        }
    }

    public static SendTutorialsMessage decode(PacketBuffer buffer) {
        int count = buffer.func_150792_a();
        ArrayList<TutorialConfig> tutorials = new ArrayList<TutorialConfig>(count);
        for (int i = 0; i < count; ++i) {
            TutorialConfig.CODEC.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)buffer.func_150793_b()).result().ifPresent(tutorials::add);
        }
        return new SendTutorialsMessage(tutorials);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> TutorialClientState.set(this.tutorials));
        ctx.get().setPacketHandled(true);
    }
}

